/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.attribute.adapters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import poussecafe.attribute.adapters.AdaptingCollection;
import poussecafe.attribute.adapters.AdaptingListIterator;
import poussecafe.attribute.adapters.DataAdapter;
import poussecafe.attribute.adapters.DataAdapters;
import poussecafe.attribute.list.EditableList;
import poussecafe.collection.ListEditor;

public class AdaptingList<U, T>
extends AdaptingCollection<U, T>
implements EditableList<T> {
    private List<U> mutableList;

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return this.mutableList.addAll(index, this.adaptFromTToU(c));
    }

    private Collection<? extends U> adaptFromTToU(Collection<? extends T> c) {
        return c.stream().map(item -> DataAdapters.nullOrAdapted(item, value -> this.adapter().adaptSet(value))).collect(Collectors.toList());
    }

    @Override
    public T get(int index) {
        return (T)DataAdapters.nullOrAdapted(this.mutableList.get(index), value -> this.adapter().adaptGet(value));
    }

    @Override
    public T set(int index, T element) {
        U previousValue = this.mutableList.set(index, this.adapter().adaptSet(element));
        return (T)DataAdapters.nullOrAdapted(previousValue, value -> this.adapter().adaptGet(value));
    }

    @Override
    public void add(int index, T element) {
        this.mutableList.add(index, this.adapter().adaptSet(element));
    }

    @Override
    public T remove(int index) {
        U previousValue = this.mutableList.remove(index);
        return (T)DataAdapters.nullOrAdapted(previousValue, value -> this.adapter().adaptGet(value));
    }

    @Override
    public int indexOf(Object o) {
        return this.find(o, this.mutableList::indexOf);
    }

    private int find(Object o, ToIntFunction<U> finder) {
        Object elementToFind;
        try {
            elementToFind = this.adapter().adaptSet(o);
        }
        catch (ClassCastException e) {
            return -1;
        }
        return finder.applyAsInt(elementToFind);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.find(o, this.mutableList::lastIndexOf);
    }

    @Override
    public ListIterator<T> listIterator() {
        return new AdaptingListIterator.Builder().adapter(this.adapter()).iterator(this.mutableList.listIterator()).build();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new AdaptingListIterator.Builder().adapter(this.adapter()).iterator(this.mutableList.listIterator(index)).build();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return new Builder().mutableList(this.mutableList.subList(fromIndex, toIndex)).adapter(this.adapter()).build();
    }

    @Override
    public ListEditor<T> edit() {
        return new ListEditor((List)this);
    }

    private AdaptingList() {
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof List) {
            return this.adaptedList().equals(obj);
        }
        return false;
    }

    private List<T> adaptedList() {
        return this.mutableList.stream().map(element -> this.adapter().adaptGet(element)).collect(Collectors.toList());
    }

    @Override
    public int hashCode() {
        return this.adaptedList().hashCode();
    }

    public String toString() {
        return this.adaptedList().toString();
    }

    public static class Builder<U, T> {
        private AdaptingList<U, T> set = new AdaptingList();

        public Builder() {
            this.set.collectionFactory(ArrayList::new);
        }

        public AdaptingList<U, T> build() {
            Objects.requireNonNull(this.set.mutableList);
            Objects.requireNonNull(this.set.adapter());
            return this.set;
        }

        public Builder<U, T> mutableList(List<U> mutableList) {
            this.set.mutableCollection(mutableList);
            this.set.mutableList = mutableList;
            return this;
        }

        public Builder<U, T> adapter(DataAdapter<U, T> adapter) {
            this.set.adapter(adapter);
            return this;
        }
    }
}

