/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.attribute.adapters;

import java.util.ListIterator;
import java.util.Objects;
import java.util.function.Consumer;
import poussecafe.attribute.adapters.AdaptingIterator;
import poussecafe.attribute.adapters.DataAdapter;
import poussecafe.attribute.adapters.DataAdapters;

public class AdaptingListIterator<U, T>
extends AdaptingIterator<U, T>
implements ListIterator<T> {
    private ListIterator<U> listIterator;
    private DataAdapter<U, T> adapter;

    @Override
    public boolean hasPrevious() {
        return this.listIterator.hasPrevious();
    }

    @Override
    public T previous() {
        return this.adapter().apply(this.listIterator.previous());
    }

    @Override
    public int nextIndex() {
        return this.listIterator.nextIndex();
    }

    @Override
    public int previousIndex() {
        return this.listIterator.previousIndex();
    }

    @Override
    public void set(T e) {
        this.listIterator.set(this.adaptToStore(e));
    }

    private U adaptToStore(T e) {
        return (U)DataAdapters.nullOrAdapted(e, value -> this.adapter.adaptSet(value));
    }

    @Override
    public void add(T e) {
        this.listIterator.add(this.adaptToStore(e));
    }

    protected AdaptingListIterator() {
    }

    public static class Builder<U, T> {
        private AdaptingListIterator<U, T> iterator = new AdaptingListIterator();

        public AdaptingListIterator<U, T> build() {
            Objects.requireNonNull(this.iterator.listIterator);
            Objects.requireNonNull(this.iterator.adapter);
            return this.iterator;
        }

        public Builder<U, T> iterator(ListIterator<U> iterator) {
            this.iterator.iterator(iterator);
            this.iterator.listIterator = iterator;
            return this;
        }

        public Builder<U, T> adapter(DataAdapter<U, T> adapter) {
            this.iterator.adapter(adapter::adaptGet);
            this.iterator.adapter = adapter;
            return this;
        }

        public Builder<U, T> onRemove(Consumer<U> onRemove) {
            this.iterator.onRemove(onRemove);
            return this;
        }
    }
}

