/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.attribute.adapters;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import poussecafe.attribute.adapters.AdaptingMapValues;
import poussecafe.attribute.adapters.AdaptingSet;
import poussecafe.attribute.adapters.DataAdapter;
import poussecafe.attribute.adapters.DataAdapters;
import poussecafe.attribute.map.EditableMap;
import poussecafe.collection.MapEditor;

public class AdaptingMap<L, U, K, V>
implements EditableMap<K, V> {
    private Map<L, U> mutableMap;
    private DataAdapter<L, K> keyAdapter;
    private DataAdapter<U, V> valueAdapter;

    @Override
    public int size() {
        return this.mutableMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mutableMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        L adaptedKey;
        try {
            adaptedKey = this.adaptKToL(key);
        }
        catch (ClassCastException e) {
            return false;
        }
        return this.mutableMap.containsKey(adaptedKey);
    }

    private L adaptKToL(K key) {
        return (L)DataAdapters.nullOrAdapted(key, this.keyAdapter::adaptSet);
    }

    @Override
    public boolean containsValue(Object value) {
        U adaptedValue;
        try {
            adaptedValue = this.adaptVToU(value);
        }
        catch (ClassCastException e) {
            return false;
        }
        return this.mutableMap.containsValue(adaptedValue);
    }

    private U adaptVToU(V value) {
        return (U)DataAdapters.nullOrAdapted(value, this.valueAdapter::adaptSet);
    }

    @Override
    public V get(Object key) {
        L adaptedKey;
        try {
            adaptedKey = this.adaptKToL(key);
        }
        catch (ClassCastException e) {
            return null;
        }
        U value = this.mutableMap.get(adaptedKey);
        if (value == null) {
            return null;
        }
        return this.adaptUToV(value);
    }

    private V adaptUToV(U value) {
        return (V)DataAdapters.nullOrAdapted(value, this.valueAdapter::adaptGet);
    }

    @Override
    public V put(K key, V value) {
        U newValue = this.adaptVToU(value);
        U previousValue = this.mutableMap.put(this.adaptKToL(key), newValue);
        if (previousValue == null) {
            return null;
        }
        return this.adaptUToV(previousValue);
    }

    @Override
    public V remove(Object key) {
        L adaptedKey;
        try {
            adaptedKey = this.adaptKToL(key);
        }
        catch (ClassCastException e) {
            return null;
        }
        U removedValue = this.mutableMap.remove(adaptedKey);
        return this.adaptUToV(removedValue);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        m.entrySet().stream().forEach((? super T entry) -> {
            Object v = this.put(entry.getKey(), entry.getValue());
        });
    }

    @Override
    public void clear() {
        this.mutableMap.clear();
    }

    @Override
    public Set<K> keySet() {
        return new AdaptingSet.Builder().mutableSet(this.mutableMap.keySet()).adapter(this.keyAdapter).build();
    }

    @Override
    public Collection<V> values() {
        return new AdaptingMapValues.Builder().mutableMap(this.mutableMap).keyAdapter(this.keyAdapter).valueAdapter(this.valueAdapter).build();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AdaptingSet.Builder().mutableSet(this.mutableMap.entrySet()).adapter(DataAdapters.mutableEntry(this.keyAdapter, this.valueAdapter, this)).build();
    }

    @Override
    public MapEditor<K, V> edit() {
        return new MapEditor((Map)this);
    }

    private AdaptingMap() {
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Map) {
            return this.adaptedMap().equals(obj);
        }
        return false;
    }

    private Map<K, V> adaptedMap() {
        return this.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public int hashCode() {
        return this.adaptedMap().hashCode();
    }

    public String toString() {
        return this.adaptedMap().toString();
    }

    public static class Builder<L, U, K, V> {
        private AdaptingMap<L, U, K, V> map = new AdaptingMap();

        public AdaptingMap<L, U, K, V> build() {
            Objects.requireNonNull(this.map.mutableMap);
            Objects.requireNonNull(this.map.keyAdapter);
            Objects.requireNonNull(this.map.valueAdapter);
            return this.map;
        }

        public Builder<L, U, K, V> mutableMap(Map<L, U> mutableMap) {
            this.map.mutableMap = mutableMap;
            return this;
        }

        public Builder<L, U, K, V> keyAdapter(DataAdapter<L, K> keyAdapter) {
            this.map.keyAdapter = keyAdapter;
            return this;
        }

        public Builder<L, U, K, V> valueAdapter(DataAdapter<U, V> valueAdapter) {
            this.map.valueAdapter = valueAdapter;
            return this;
        }
    }
}

