/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.attribute.adapters;

import java.util.Map;
import java.util.Objects;
import poussecafe.attribute.adapters.DataAdapter;
import poussecafe.attribute.map.ImmutableEntry;

public class AdaptingMapEntry<L, U, K, V>
implements Map.Entry<K, V> {
    private Map.Entry<L, U> entry;
    private DataAdapter<L, K> keyAdapter;
    private DataAdapter<U, V> valueAdapter;
    private Map<K, V> mutableMap;

    @Override
    public K getKey() {
        return this.keyAdapter.adaptGet(this.entry.getKey());
    }

    public Map.Entry<L, U> underlyingEntry() {
        return this.entry;
    }

    @Override
    public V getValue() {
        U value = this.entry.getValue();
        if (value == null) {
            return null;
        }
        return this.valueAdapter.adaptGet(value);
    }

    @Override
    public V setValue(V value) {
        U previousValue = this.entry.getValue();
        K key = this.keyAdapter.adaptGet(this.entry.getKey());
        this.mutableMap.put(key, value);
        return this.valueAdapter.adaptGet(previousValue);
    }

    private AdaptingMapEntry() {
    }

    @Override
    public int hashCode() {
        return this.adaptedEntry().hashCode();
    }

    private ImmutableEntry<K, V> adaptedEntry() {
        return new ImmutableEntry<K, V>(this.getKey(), this.getValue());
    }

    @Override
    public boolean equals(Object obj) {
        return this.adaptedEntry().equals(obj);
    }

    public String toString() {
        return this.adaptedEntry().toString();
    }

    public static class Builder<L, U, K, V> {
        private AdaptingMapEntry<L, U, K, V> entry = new AdaptingMapEntry();

        public AdaptingMapEntry<L, U, K, V> build() {
            Objects.requireNonNull(this.entry.entry);
            Objects.requireNonNull(this.entry.keyAdapter);
            Objects.requireNonNull(this.entry.valueAdapter);
            return this.entry;
        }

        public Builder<L, U, K, V> entry(Map.Entry<L, U> entry) {
            this.entry.entry = entry;
            return this;
        }

        public Builder<L, U, K, V> keyAdapter(DataAdapter<L, K> keyAdapter) {
            this.entry.keyAdapter = keyAdapter;
            return this;
        }

        public Builder<L, U, K, V> valueAdapter(DataAdapter<U, V> valueAdapter) {
            this.entry.valueAdapter = valueAdapter;
            return this;
        }

        public Builder<L, U, K, V> mutableMap(Map<K, V> mutableMap) {
            this.entry.mutableMap = mutableMap;
            return this;
        }
    }
}

