/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.attribute.adapters;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import poussecafe.attribute.adapters.AdaptingMapValuesIterator;
import poussecafe.attribute.adapters.Arrays;
import poussecafe.attribute.adapters.DataAdapter;

public class AdaptingMapValues<L, U, K, V>
implements Collection<V> {
    private Map<L, U> mutableMap;
    private DataAdapter<L, K> keyAdapter;
    private DataAdapter<U, V> valueAdapter;

    @Override
    public int size() {
        return this.mutableMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mutableMap.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        U value;
        try {
            value = this.valueAdapter.adaptSet(o);
        }
        catch (ClassCastException e) {
            return false;
        }
        return this.mutableMap.containsValue(value);
    }

    @Override
    public Iterator<V> iterator() {
        return new AdaptingMapValuesIterator.Builder().entrySetIterator(this.mutableMap.entrySet().iterator()).valueAdapter(this.valueAdapter).build();
    }

    @Override
    public Object[] toArray() {
        return Arrays.toAdaptedArray(this.mutableMap.values(), this.valueAdapter::adaptGet);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return Arrays.toAdaptedArray(this.mutableMap.values(), this.valueAdapter::adaptGet, a);
    }

    @Override
    public boolean add(V e) {
        throw new UnsupportedOperationException("add");
    }

    @Override
    public boolean remove(Object o) {
        U value;
        try {
            value = this.valueAdapter.adaptSet(o);
        }
        catch (ClassCastException e) {
            return false;
        }
        return this.mutableMap.values().remove(value);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return c.stream().allMatch(this::contains);
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        throw new UnsupportedOperationException("addAll");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean someRemoved = false;
        for (Object element : c) {
            if (!this.remove(element)) continue;
            someRemoved = true;
        }
        return someRemoved;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean someRemoved = false;
        Iterator<V> iterator = this.iterator();
        while (iterator.hasNext()) {
            V next = iterator.next();
            if (c.contains(next)) continue;
            iterator.remove();
            someRemoved = true;
        }
        return someRemoved;
    }

    @Override
    public void clear() {
        this.mutableMap.clear();
    }

    public static class Builder<L, U, K, V> {
        private AdaptingMapValues<L, U, K, V> values = new AdaptingMapValues();

        public AdaptingMapValues<L, U, K, V> build() {
            Objects.requireNonNull(this.values.mutableMap);
            Objects.requireNonNull(this.values.keyAdapter);
            Objects.requireNonNull(this.values.valueAdapter);
            return this.values;
        }

        public Builder<L, U, K, V> mutableMap(Map<L, U> mutableMap) {
            this.values.mutableMap = mutableMap;
            return this;
        }

        public Builder<L, U, K, V> keyAdapter(DataAdapter<L, K> keyAdapter) {
            this.values.keyAdapter = keyAdapter;
            return this;
        }

        public Builder<L, U, K, V> valueAdapter(DataAdapter<U, V> valueAdapter) {
            this.values.valueAdapter = valueAdapter;
            return this;
        }
    }
}

