/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.attribute.adapters;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import poussecafe.attribute.adapters.DataAdapter;

public class AdaptingMapValuesIterator<L, U, K, V>
implements Iterator<V> {
    private Iterator<Map.Entry<L, U>> entrySetIterator;
    private DataAdapter<U, V> valueAdapter;

    @Override
    public boolean hasNext() {
        return this.entrySetIterator.hasNext();
    }

    @Override
    public V next() {
        Map.Entry<L, U> next = this.entrySetIterator.next();
        return this.valueAdapter.adaptGet(next.getValue());
    }

    @Override
    public void remove() {
        this.entrySetIterator.remove();
    }

    private AdaptingMapValuesIterator() {
    }

    public static class Builder<L, U, K, V> {
        private AdaptingMapValuesIterator<L, U, K, V> iterator = new AdaptingMapValuesIterator();

        public AdaptingMapValuesIterator<L, U, K, V> build() {
            Objects.requireNonNull(this.iterator.entrySetIterator);
            Objects.requireNonNull(this.iterator.valueAdapter);
            return this.iterator;
        }

        public Builder<L, U, K, V> entrySetIterator(Iterator<Map.Entry<L, U>> entrySetIterator) {
            this.iterator.entrySetIterator = entrySetIterator;
            return this;
        }

        public Builder<L, U, K, V> valueAdapter(DataAdapter<U, V> valueAdapter) {
            this.iterator.valueAdapter = valueAdapter;
            return this;
        }
    }
}

