/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.attribute.adapters;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import poussecafe.attribute.adapters.AdaptingCollection;
import poussecafe.attribute.adapters.DataAdapter;
import poussecafe.attribute.set.EditableSet;
import poussecafe.collection.SetEditor;

public class AdaptingSet<U, T>
extends AdaptingCollection<U, T>
implements EditableSet<T> {
    @Override
    public SetEditor<T> edit() {
        return new SetEditor((Set)this);
    }

    private AdaptingSet() {
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Set) {
            return this.adaptedSet().equals(obj);
        }
        return false;
    }

    private Set<T> adaptedSet() {
        return this.mutableCollection().stream().map(element -> this.adapter().adaptGet(element)).collect(Collectors.toSet());
    }

    @Override
    public int hashCode() {
        return this.adaptedSet().hashCode();
    }

    public String toString() {
        return this.adaptedSet().toString();
    }

    public static class Builder<U, T> {
        private AdaptingSet<U, T> set = new AdaptingSet();

        public Builder() {
            this.set.collectionFactory(HashSet::new);
        }

        public AdaptingSet<U, T> build() {
            Objects.requireNonNull(this.set.mutableCollection());
            Objects.requireNonNull(this.set.adapter());
            return this.set;
        }

        public Builder<U, T> mutableSet(Set<U> mutableSet) {
            this.set.mutableCollection(mutableSet);
            return this;
        }

        public Builder<U, T> adapter(DataAdapter<U, T> adapter) {
            this.set.adapter(adapter);
            return this;
        }
    }
}

