/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.attribute.adapters;

import java.util.Collection;
import java.util.function.Function;
import poussecafe.attribute.adapters.AdaptingIterator;

public class Arrays {
    public static <U, T> Object[] toAdaptedArray(Collection<U> collection, Function<U, T> adapter) {
        Object[] array = new Object[collection.size()];
        Arrays.copyIntoArray(collection, adapter, array);
        return array;
    }

    private static <U, T> void copyIntoArray(Collection<U> collection, Function<U, T> adapter, Object[] destination) {
        AdaptingIterator iterator = new AdaptingIterator.Builder().iterator(collection.iterator()).adapter(adapter).build();
        int i = 0;
        while (i < collection.size()) {
            destination[i] = iterator.next();
            ++i;
        }
    }

    public static <U, T> Object[] toAdaptedArray(Collection<U> collection, Function<U, T> adapter, T[] destination) {
        Object[] array = destination.length < collection.size() ? new Object[collection.size()] : destination;
        Arrays.copyIntoArray(collection, adapter, array);
        return array;
    }

    private Arrays() {
    }
}

