/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.attribute.adapters;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import poussecafe.attribute.adapters.DataAdapter;
import poussecafe.exception.PousseCafeException;

public class AutoAdaptingDataAdapter<U, T>
implements DataAdapter<U, T> {
    private Class<T> propertyTypeClass;
    private Class<U> dataAdapterClass;

    public AutoAdaptingDataAdapter(Class<T> propertyTypeClass, Class<U> dataAdapterClass) {
        this.propertyTypeClass = propertyTypeClass;
        this.dataAdapterClass = dataAdapterClass;
        this.requiresDataAdapter();
    }

    private void requiresDataAdapter() {
        Method setAdapter = this.setAdapter();
        if (!Modifier.isStatic(setAdapter.getModifiers())) {
            throw new PousseCafeException("adapt(" + this.propertyTypeClass.getSimpleName() + ") is not static");
        }
        Method getAdapter = this.getAdapter();
        if (getAdapter.getReturnType() != this.propertyTypeClass) {
            throw new PousseCafeException("adapt() does not return " + this.propertyTypeClass.getSimpleName());
        }
    }

    private Method setAdapter() {
        try {
            return this.dataAdapterClass.getMethod("adapt", this.propertyTypeClass);
        }
        catch (Exception e) {
            throw new PousseCafeException("Missing adapt(" + this.propertyTypeClass.getSimpleName() + ")", (Throwable)e);
        }
    }

    private Method getAdapter() {
        try {
            return this.dataAdapterClass.getMethod("adapt", new Class[0]);
        }
        catch (Exception e) {
            throw new PousseCafeException("Missing adapt()", (Throwable)e);
        }
    }

    @Override
    public T adaptGet(U u) {
        try {
            return (T)this.getAdapter().invoke(u, new Object[0]);
        }
        catch (Exception e) {
            throw new PousseCafeException("Unable to adapt data while getting", (Throwable)e);
        }
    }

    @Override
    public U adaptSet(T value) {
        try {
            return (U)this.setAdapter().invoke(null, value);
        }
        catch (Exception e) {
            throw new PousseCafeException("Unable to adapt data while setting", (Throwable)e);
        }
    }
}

