/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.attribute.adapters;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import poussecafe.attribute.adapters.CollectionBackedAdaptingMapEntries;
import poussecafe.attribute.adapters.CollectionBackedAdaptingMapKeys;
import poussecafe.attribute.adapters.CollectionBackedAdaptingMapValues;
import poussecafe.attribute.adapters.DataAdapter;
import poussecafe.attribute.map.EditableMap;
import poussecafe.attribute.map.ImmutableEntry;
import poussecafe.collection.MapEditor;

public class CollectionBackedAdaptingMap<U, K, V>
implements EditableMap<K, V> {
    private Collection<U> collection;
    private Map<K, V> mapView;
    private CollectionBackedAdaptingMapValues<U, K, V> values;
    private CollectionBackedAdaptingMapKeys<U, K, V> keys;
    private CollectionBackedAdaptingMapEntries<U, K, V> entries;
    private DataAdapter<U, Map.Entry<K, V>> adapter;

    private void computeViews() {
        this.mapView = this.collection.stream().collect(this.toConvertedFromMap());
        this.values = new CollectionBackedAdaptingMapValues();
        this.values.collection = this.collection;
        this.values.adapter = this.adapter;
        this.values.mapView = this.mapView;
        this.keys = new CollectionBackedAdaptingMapKeys();
        this.keys.collection = this.collection;
        this.keys.adapter = this.adapter;
        this.keys.mapView = this.mapView;
        this.entries = new CollectionBackedAdaptingMapEntries();
        this.entries.collection = this.collection;
        this.entries.adapter = this.adapter;
        this.entries.mapView = this.mapView;
        this.entries.mutableMap = this;
    }

    private Collector<U, ?, Map<K, V>> toConvertedFromMap() {
        return Collectors.toMap(item -> this.adapter.adaptGet(item).getKey(), item -> this.adapter.adaptGet(item).getValue());
    }

    @Override
    public V get(Object key) {
        return this.mapView.get(key);
    }

    @Override
    public V put(K key, V value) {
        V oldValue = this.remove(key);
        this.mapView.put(key, value);
        this.collection.add(this.adapter.adaptSet(new ImmutableEntry<K, V>(key, value)));
        return oldValue;
    }

    @Override
    public Collection<V> values() {
        return this.values;
    }

    @Override
    public V remove(Object key) {
        V oldValue = this.mapView.get(key);
        this.keys.remove(key);
        return oldValue;
    }

    @Override
    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.mapView.containsKey(key);
    }

    @Override
    public Set<K> keySet() {
        return this.keys;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entries;
    }

    @Override
    public int size() {
        return this.collection.size();
    }

    @Override
    public void clear() {
        this.collection.clear();
        this.mapView.clear();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        map.entrySet().stream().forEach((? super T entry) -> {
            Object v = this.put(entry.getKey(), entry.getValue());
        });
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.contains(value);
    }

    @Override
    public MapEditor<K, V> edit() {
        return new MapEditor((Map)this);
    }

    private CollectionBackedAdaptingMap() {
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Map) {
            return this.mapView.equals(obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.mapView.hashCode();
    }

    public String toString() {
        return this.mapView.toString();
    }

    public static class Builder<U, K, V> {
        private CollectionBackedAdaptingMap<U, K, V> map = new CollectionBackedAdaptingMap();

        public CollectionBackedAdaptingMap<U, K, V> build() {
            Objects.requireNonNull(this.map.collection);
            Objects.requireNonNull(this.map.adapter);
            this.map.computeViews();
            return this.map;
        }

        public Builder<U, K, V> collection(Collection<U> collection) {
            this.map.collection = collection;
            return this;
        }

        public Builder<U, K, V> adapter(DataAdapter<U, Map.Entry<K, V>> adapter) {
            this.map.adapter = adapter;
            return this;
        }
    }
}

