/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.attribute.adapters;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import poussecafe.attribute.adapters.AdaptingIterator;
import poussecafe.attribute.adapters.Arrays;
import poussecafe.attribute.adapters.DataAdapter;

abstract class CollectionBackedAdaptingMapView<U, K, V, X>
implements Collection<X> {
    protected Collection<U> collection;
    protected Map<K, V> mapView;
    protected DataAdapter<U, Map.Entry<K, V>> adapter;

    CollectionBackedAdaptingMapView() {
    }

    @Override
    public int size() {
        return this.collection.size();
    }

    @Override
    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    @Override
    public Iterator<X> iterator() {
        return new AdaptingIterator.Builder().iterator(this.collection.iterator()).adapter(item -> this.applyProjection(this.adapter.adaptGet(item))).onRemove(item -> {
            V v = this.mapView.remove(this.adapter.adaptGet(item).getKey());
        }).build();
    }

    protected abstract X applyProjection(Map.Entry<K, V> var1);

    @Override
    public Object[] toArray() {
        return Arrays.toAdaptedArray(this.collection, item -> this.applyProjection(this.adapter.adaptGet(item)));
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return Arrays.toAdaptedArray(this.collection, item -> this.applyProjection(this.adapter.adaptGet(item)), a);
    }

    @Override
    public boolean add(X e) {
        throw new UnsupportedOperationException("add");
    }

    @Override
    public boolean addAll(Collection<? extends X> c) {
        throw new UnsupportedOperationException("addAll");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        int previousSize = this.size();
        c.forEach(this::remove);
        return previousSize != this.size();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Iterator<X> iterator = this.iterator();
        boolean anyRemoved = false;
        while (iterator.hasNext()) {
            X next = iterator.next();
            if (c.contains(next)) continue;
            iterator.remove();
            anyRemoved = true;
        }
        return anyRemoved;
    }

    @Override
    public void clear() {
        this.collection.clear();
        this.mapView.clear();
    }

    void flushViewToCollection() {
        this.collection.clear();
        this.collection.addAll(this.mapView.entrySet().stream().map(this.adapter::adaptSet).collect(Collectors.toList()));
    }
}

