/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.attribute.adapters;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import poussecafe.attribute.adapters.AdaptingMapEntry;
import poussecafe.attribute.adapters.AutoAdaptingDataAdapter;
import poussecafe.attribute.adapters.DataAdapter;
import poussecafe.exception.PousseCafeException;
import poussecafe.util.StringId;

public class DataAdapters {
    public static <U, T> DataAdapter<U, T> adapter(final Function<U, T> adaptGet, final Function<T, U> adaptSet) {
        return new DataAdapter<U, T>(){

            @Override
            public T adaptGet(U storedValue) {
                return adaptGet.apply(storedValue);
            }

            @Override
            public U adaptSet(T valueToStore) {
                return adaptSet.apply(valueToStore);
            }
        };
    }

    public static DataAdapter<String, LocalDate> stringLocalDate() {
        return DataAdapters.adapter(LocalDate::parse, LocalDate::toString);
    }

    public static DataAdapter<String, LocalDateTime> stringLocalDateTime() {
        return DataAdapters.adapter(LocalDateTime::parse, LocalDateTime::toString);
    }

    public static DataAdapter<String, OffsetDateTime> stringOffsetDateTime() {
        return DataAdapters.adapter(OffsetDateTime::parse, OffsetDateTime::toString);
    }

    public static DataAdapter<String, BigDecimal> stringBigDecimal() {
        return DataAdapters.adapter(BigDecimal::new, BigDecimal::toString);
    }

    public static <T extends StringId> DataAdapter<String, T> stringId(final Class<T> stringIdClass) {
        Objects.requireNonNull(stringIdClass);
        return new DataAdapter<String, T>(){

            @Override
            public T adaptGet(String storedValue) {
                try {
                    return (StringId)stringIdClass.getConstructor(String.class).newInstance(storedValue);
                }
                catch (Exception e) {
                    throw new PousseCafeException("Unable to adapt string id", (Throwable)e);
                }
            }

            @Override
            public String adaptSet(T valueToStore) {
                return valueToStore.stringValue();
            }
        };
    }

    public static <E extends Enum<E>> DataAdapter<String, E> stringEnum(final Class<E> enumClass) {
        Objects.requireNonNull(enumClass);
        return new DataAdapter<String, E>(){

            @Override
            public E adaptGet(String storedValue) {
                return Enum.valueOf(enumClass, storedValue);
            }

            @Override
            public String adaptSet(E valueToStore) {
                return ((Enum)valueToStore).name();
            }
        };
    }

    public static <U, T> DataAdapter<U, T> auto(Class<T> propertyTypeClass, Class<U> dataAdapterClass) {
        return new AutoAdaptingDataAdapter<U, T>(propertyTypeClass, dataAdapterClass);
    }

    public static <T> DataAdapter<T, T> identity() {
        return DataAdapters.adapter(value -> value, value -> value);
    }

    public static <U, T> DataAdapter<List<U>, List<T>> listWithAdapter(final DataAdapter<U, T> adapter) {
        return new DataAdapter<List<U>, List<T>>(){

            @Override
            public List<T> adaptGet(List<U> storedValue) {
                return storedValue.stream().map(adapter::adaptGet).collect(Collectors.toList());
            }

            @Override
            public List<U> adaptSet(List<T> valueToStore) {
                return valueToStore.stream().map(adapter::adaptSet).collect(Collectors.toList());
            }
        };
    }

    public static <T> Class<List<T>> parametrizedListClass(Class<T> elementType) {
        Objects.requireNonNull(elementType);
        return Collections.emptyList().getClass();
    }

    public static DataAdapter<String, byte[]> stringByteArray() {
        return new DataAdapter<String, byte[]>(){

            @Override
            public byte[] adaptGet(String storedValue) {
                return Base64.getDecoder().decode(storedValue);
            }

            @Override
            public String adaptSet(byte[] valueToStore) {
                return Base64.getEncoder().encodeToString(valueToStore);
            }
        };
    }

    public static <L, U, K, V> DataAdapter<Map.Entry<L, U>, Map.Entry<K, V>> mutableEntry(final DataAdapter<L, K> keyAdapter, final DataAdapter<U, V> valueAdapter, final Map<K, V> mutableMap) {
        return new DataAdapter<Map.Entry<L, U>, Map.Entry<K, V>>(){

            @Override
            public Map.Entry<K, V> adaptGet(Map.Entry<L, U> storedValue) {
                return new AdaptingMapEntry.Builder().entry(storedValue).keyAdapter(keyAdapter).valueAdapter(valueAdapter).mutableMap(mutableMap).build();
            }

            @Override
            public Map.Entry<L, U> adaptSet(Map.Entry<K, V> valueToStore) {
                if (valueToStore instanceof AdaptingMapEntry) {
                    AdaptingMapEntry adaptingEntry = (AdaptingMapEntry)valueToStore;
                    return adaptingEntry.underlyingEntry();
                }
                return null;
            }
        };
    }

    public static <F, T> T nullOrAdapted(F from, Function<F, T> adapter) {
        if (from == null) {
            return null;
        }
        return adapter.apply(from);
    }

    private DataAdapters() {
    }
}

