/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.attribute.list;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import poussecafe.attribute.ListAttribute;
import poussecafe.attribute.adapters.AutoAdaptingDataAdapter;
import poussecafe.attribute.adapters.DataAdapter;
import poussecafe.attribute.list.DataAdapterBasedListAttributeBuilder;
import poussecafe.attribute.list.FunctionAdapterBasedListAttributeBuilder;
import poussecafe.attribute.list.NoAdaptingListAttributeBuilder;

public class ListAttributeBuilder<T> {
    private Class<T> elementClass;

    public ListAttributeBuilder(Class<T> elementClass) {
        Objects.requireNonNull(elementClass);
        this.elementClass = elementClass;
    }

    public Complete<T> withList(List<T> list) {
        Objects.requireNonNull(list);
        return new NoAdaptingListAttributeBuilder<T>(list);
    }

    public <U> ExpectingReadAdapters<U, T> itemsStoredAs(Class<U> storedElementType) {
        Objects.requireNonNull(storedElementType);
        return new FunctionAdapterBasedListAttributeBuilder();
    }

    public <U> ExpectingList<U, T> usingItemAutoAdapter(Class<U> dataAdapterClass) {
        return this.usingItemDataAdapter(new AutoAdaptingDataAdapter<U, T>(this.elementClass, dataAdapterClass));
    }

    public <U> ExpectingList<U, T> usingItemDataAdapter(DataAdapter<U, T> dataAdapter) {
        Objects.requireNonNull(dataAdapter);
        DataAdapterBasedListAttributeBuilder builder = new DataAdapterBasedListAttributeBuilder();
        builder.adapter = dataAdapter;
        return builder;
    }

    public static interface Complete<T> {
        public ListAttribute<T> build();
    }

    public static interface ExpectingList<U, T> {
        public Complete<T> withList(List<U> var1);
    }

    public static interface ExpectingReadAdapters<U, T> {
        public ExpectingWriteAdapters<U, T> adaptOnGet(Function<U, T> var1);
    }

    public static interface ExpectingWriteAdapters<U, T> {
        public ExpectingList<U, T> adaptOnSet(Function<T, U> var1);
    }
}

