/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.attribute.map;

import java.util.Map;
import java.util.Objects;
import poussecafe.util.Equality;

public class ImmutableEntry<T, S>
implements Map.Entry<T, S> {
    private T key;
    private S value;

    public ImmutableEntry(T key, S value) {
        Objects.requireNonNull(key);
        this.key = key;
        this.value = value;
    }

    @Override
    public T getKey() {
        return this.key;
    }

    @Override
    public S getValue() {
        return this.value;
    }

    @Override
    public S setValue(S value) {
        throw new UnsupportedOperationException("setValue");
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Map.Entry) {
            Map.Entry e = (Map.Entry)obj;
            return Equality.bothNullOrEqual(this.key, e.getKey()) && Equality.bothNullOrEqual(this.value, e.getValue());
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{key=");
        builder.append(this.key);
        builder.append(", value=");
        builder.append("}");
        return builder.toString();
    }
}

