/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.attribute.map;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import poussecafe.attribute.MapAttribute;
import poussecafe.attribute.adapters.DataAdapter;
import poussecafe.attribute.map.CollectionBackedMapAttribute;
import poussecafe.attribute.map.ImmutableEntry;
import poussecafe.attribute.map.MapAttributeBuilder;

class ItemAdapterBasedMapAttributeBuilder<U, K, V>
implements MapAttributeBuilder.ExpectingCollection<U, K, V>,
MapAttributeBuilder.ExpectingKeyExtractor<U, K, V>,
MapAttributeBuilder.Complete<K, V> {
    DataAdapter<U, V> itemAdapter;
    Function<V, K> keyExtractor;
    Collection<U> collection;

    ItemAdapterBasedMapAttributeBuilder() {
    }

    @Override
    public MapAttributeBuilder.ExpectingCollection<U, K, V> withKeyExtractor(Function<V, K> keyExtractor) {
        this.keyExtractor = keyExtractor;
        return this;
    }

    @Override
    public MapAttributeBuilder.Complete<K, V> withCollection(Collection<U> collection) {
        this.collection = collection;
        return this;
    }

    @Override
    public MapAttribute<K, V> build() {
        return new CollectionBackedMapAttribute<U, K, V>(this.collection){

            @Override
            protected Map.Entry<K, V> convertFromValue(U from) {
                Object value = ItemAdapterBasedMapAttributeBuilder.this.itemAdapter.adaptGet(from);
                return new ImmutableEntry(ItemAdapterBasedMapAttributeBuilder.this.keyExtractor.apply(value), value);
            }

            @Override
            protected U convertToValue(Map.Entry<K, V> from) {
                return ItemAdapterBasedMapAttributeBuilder.this.itemAdapter.adaptSet(from.getValue());
            }
        };
    }
}

