/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.attribute.map;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import poussecafe.attribute.MapAttribute;
import poussecafe.attribute.adapters.DataAdapter;
import poussecafe.attribute.map.EntryAdapterBasedMapAttributeBuilder;
import poussecafe.attribute.map.FunctionAdapterBasedMapAttributeBuilder;
import poussecafe.attribute.map.ItemAdapterBasedMapAttributeBuilder;
import poussecafe.attribute.map.KeyValueAdaptersBasedMapAttributeBuilder;
import poussecafe.attribute.map.NoAdaptingMapAttributeBuilder;

public class MapAttributeBuilder<K, V> {
    public Complete<K, V> withMap(Map<K, V> map) {
        Objects.requireNonNull(map);
        return new NoAdaptingMapAttributeBuilder<K, V>(map);
    }

    public <J, U> FunctionAdapterBasedMapAttributeBuilder<J, U, K, V> entriesStoredAs(Class<J> storedKeyType, Class<U> storedValueType) {
        return new FunctionAdapterBasedMapAttributeBuilder();
    }

    public <J, U> ExpectingMap<J, U, K, V> usingEntryDataAdapters(DataAdapter<J, K> keyAdapter, DataAdapter<U, V> valueAdapter) {
        KeyValueAdaptersBasedMapAttributeBuilder builder = new KeyValueAdaptersBasedMapAttributeBuilder();
        Objects.requireNonNull(keyAdapter);
        builder.keyAdapter = keyAdapter;
        Objects.requireNonNull(valueAdapter);
        builder.valueAdapter = valueAdapter;
        return builder;
    }

    public <U> ExpectingCollection<U, K, V> usingEntryDataAdapter(DataAdapter<U, Map.Entry<K, V>> entryAdapter) {
        EntryAdapterBasedMapAttributeBuilder builder = new EntryAdapterBasedMapAttributeBuilder();
        Objects.requireNonNull(entryAdapter);
        builder.entryAdapter = entryAdapter;
        return builder;
    }

    public <U> ExpectingKeyExtractor<U, K, V> usingItemDataAdapter(DataAdapter<U, V> itemAdapter) {
        ItemAdapterBasedMapAttributeBuilder builder = new ItemAdapterBasedMapAttributeBuilder();
        Objects.requireNonNull(itemAdapter);
        builder.itemAdapter = itemAdapter;
        return builder;
    }

    public static interface Complete<K, V> {
        public MapAttribute<K, V> build();
    }

    public static interface ExpectingCollection<U, K, V> {
        public Complete<K, V> withCollection(Collection<U> var1);
    }

    public static interface ExpectingKeyExtractor<U, K, V> {
        public ExpectingCollection<U, K, V> withKeyExtractor(Function<V, K> var1);
    }

    public static interface ExpectingMap<J, U, K, V> {
        public Complete<K, V> withMap(Map<J, U> var1);
    }

    public static interface ExpectingReadAdapters<J, U, K, V> {
        public ExpectingWriteAdapters<J, U, K, V> adaptOnRead(Function<J, K> var1, Function<U, V> var2);
    }

    public static interface ExpectingWriteAdapters<J, U, K, V> {
        public ExpectingMap<J, U, K, V> adaptOnWrite(Function<K, J> var1, Function<V, U> var2);
    }
}

