/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.attribute.optional;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import poussecafe.attribute.OptionalAttribute;
import poussecafe.attribute.adapters.DataAdapter;
import poussecafe.attribute.optional.BaseOptionalAttribute;
import poussecafe.attribute.optional.OptionalAttributeBuilder;

class DataAdapterBasedOptionalAttributeBuilder<U, T>
implements OptionalAttributeBuilder.ExpectingAdaptedReader<U, T>,
OptionalAttributeBuilder.ExpectingWriterAfterAdapter<U, T>,
OptionalAttributeBuilder.Complete<T> {
    private DataAdapter<U, T> adapter;
    private Supplier<U> getter;
    private Consumer<U> setter;

    DataAdapterBasedOptionalAttributeBuilder(DataAdapter<U, T> adapter) {
        Objects.requireNonNull(adapter);
        this.adapter = adapter;
    }

    @Override
    public OptionalAttributeBuilder.ExpectingWriterAfterAdapter<U, T> read(Supplier<U> getter) {
        Objects.requireNonNull(getter);
        this.getter = getter;
        return this;
    }

    @Override
    public OptionalAttributeBuilder.Complete<T> write(Consumer<U> setter) {
        Objects.requireNonNull(setter);
        this.setter = setter;
        return this;
    }

    @Override
    public OptionalAttribute<T> build() {
        return new BaseOptionalAttribute<T>(){

            @Override
            public T nullableValue() {
                Object storedValue = DataAdapterBasedOptionalAttributeBuilder.this.getter.get();
                if (storedValue == null) {
                    return null;
                }
                return DataAdapterBasedOptionalAttributeBuilder.this.adapter.adaptGet(storedValue);
            }

            @Override
            public void optionalValue(T nullableValue) {
                if (nullableValue == null) {
                    DataAdapterBasedOptionalAttributeBuilder.this.setter.accept(null);
                } else {
                    DataAdapterBasedOptionalAttributeBuilder.this.setter.accept(DataAdapterBasedOptionalAttributeBuilder.this.adapter.adaptSet(nullableValue));
                }
            }
        };
    }
}

