/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.attribute.set;

import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import poussecafe.attribute.SetAttribute;
import poussecafe.attribute.adapters.AutoAdaptingDataAdapter;
import poussecafe.attribute.adapters.DataAdapter;
import poussecafe.attribute.set.DataAdapterBasedSetAttributeBuilder;
import poussecafe.attribute.set.FunctionAdapterBasedSetAttributeBuilder;
import poussecafe.attribute.set.NoAdaptingSetAttributeBuilder;

public class SetAttributeBuilder<T> {
    private Class<T> elementClass;

    public SetAttributeBuilder(Class<T> elementClass) {
        Objects.requireNonNull(elementClass);
        this.elementClass = elementClass;
    }

    public Complete<T> withSet(Set<T> set) {
        Objects.requireNonNull(set);
        return new NoAdaptingSetAttributeBuilder<T>(set);
    }

    public <U> ExpectingReadAdapters<U, T> itemsStoredAs(Class<U> storedElementType) {
        Objects.requireNonNull(storedElementType);
        return new FunctionAdapterBasedSetAttributeBuilder();
    }

    public <U> ExpectingSet<U, T> usingItemAutoAdapter(Class<U> dataAdapterClass) {
        return this.usingItemDataAdapter(new AutoAdaptingDataAdapter<U, T>(this.elementClass, dataAdapterClass));
    }

    public <U> ExpectingSet<U, T> usingItemDataAdapter(DataAdapter<U, T> dataAdapter) {
        return new DataAdapterBasedSetAttributeBuilder<U, T>(dataAdapter);
    }

    public static interface Complete<T> {
        public SetAttribute<T> build();
    }

    public static interface ExpectingReadAdapters<U, T> {
        public ExpectingWriteAdapters<U, T> adaptOnGet(Function<U, T> var1);
    }

    public static interface ExpectingSet<U, T> {
        public Complete<T> withSet(Set<U> var1);
    }

    public static interface ExpectingWriteAdapters<U, T> {
        public ExpectingSet<U, T> adaptOnSet(Function<T, U> var1);
    }
}

