/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.attribute.single;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import poussecafe.attribute.Attribute;
import poussecafe.attribute.adapters.DataAdapter;
import poussecafe.attribute.single.SingleAttributeBuilder;

class DataAdapterBasedSingleAttributeBuilder<U, T>
implements SingleAttributeBuilder.ExpectingAdaptedReader<U, T>,
SingleAttributeBuilder.ExpectingAdaptedWriter<U, T>,
SingleAttributeBuilder.Complete<T> {
    private DataAdapter<U, T> adapter;
    private Supplier<U> getter;
    private Consumer<U> setter;

    DataAdapterBasedSingleAttributeBuilder(DataAdapter<U, T> adapter) {
        Objects.requireNonNull(adapter);
        this.adapter = adapter;
    }

    @Override
    public SingleAttributeBuilder.ExpectingAdaptedWriter<U, T> read(Supplier<U> getter) {
        Objects.requireNonNull(getter);
        this.getter = getter;
        return this;
    }

    @Override
    public SingleAttributeBuilder.Complete<T> write(Consumer<U> setter) {
        Objects.requireNonNull(setter);
        this.setter = setter;
        return this;
    }

    @Override
    public Attribute<T> build() {
        return new Attribute<T>(){

            @Override
            public T value() {
                Object storedValue = DataAdapterBasedSingleAttributeBuilder.this.getter.get();
                Objects.requireNonNull(storedValue, "Stored value cannot be null");
                return DataAdapterBasedSingleAttributeBuilder.this.adapter.adaptGet(storedValue);
            }

            @Override
            public void value(T value) {
                Objects.requireNonNull(value, "Stored value cannot be null");
                DataAdapterBasedSingleAttributeBuilder.this.setter.accept(DataAdapterBasedSingleAttributeBuilder.this.adapter.adaptSet(value));
            }
        };
    }
}

