/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import poussecafe.exception.PousseCafeException;
import poussecafe.messaging.Message;
import poussecafe.messaging.MessageAdapter;

public class JacksonMessageAdapter
implements MessageAdapter {
    private ObjectMapper objectMapper = this.initObjectMapper();

    public Message adaptSerializedMessage(Object serializedMessage) {
        try {
            return (Message)this.objectMapper.readValue((String)serializedMessage, Message.class);
        }
        catch (Exception e) {
            throw new PousseCafeException("Unable to adapt serialized message " + serializedMessage, (Throwable)e);
        }
    }

    protected ObjectMapper initObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.setConfig(mapper.getSerializationConfig().without(SerializationFeature.FAIL_ON_EMPTY_BEANS));
        mapper.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);
        mapper.setVisibility(mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        return mapper;
    }

    public String adaptMessage(Message message) {
        try {
            return this.objectMapper.writeValueAsString((Object)message);
        }
        catch (JsonProcessingException e) {
            throw new PousseCafeException("Unable to adapt message " + message, (Throwable)e);
        }
    }
}

