/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.examples.dom4j;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.XMLWriter;

public abstract class AbstractXMLRequestCreatorBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] convertDocumentToByteArray(Document document) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        XMLWriter writer = new XMLWriter((OutputStream)stream);
        byte[] documentAsByteArray = null;
        try {
            writer.write(document);
        }
        finally {
            writer.close();
            stream.flush();
            stream.close();
        }
        documentAsByteArray = stream.toByteArray();
        return documentAsByteArray;
    }

    public final byte[] createRequest(String ... params) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("EncodeElement");
        Element header = root.addElement("MyHeader");
        header.addAttribute("MyMsgIdAttribute", this.generateRandomId());
        Element body = root.addElement("BodyElement");
        this.createBody(body, params);
        byte[] array = null;
        try {
            array = this.convertDocumentToByteArray(document);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create request", e);
        }
        return array;
    }

    protected abstract void createBody(Element var1, String ... var2);

    String generateRandomId() {
        return Integer.toString(new Random(System.nanoTime()).nextInt(1000));
    }
}

