/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.agent.support;

import org.powermock.core.MockRepository;
import org.powermock.core.agent.JavaAgentClassRegister;
import org.powermock.modules.agent.PowerMockClassRedefiner;
import org.powermock.reflect.Whitebox;
import org.powermock.reflect.proxyframework.RegisterProxyFramework;
import org.powermock.tests.utils.impl.MockPolicyInitializerImpl;
import org.powermock.tests.utils.impl.PowerMockIgnorePackagesExtractorImpl;
import org.powermock.tests.utils.impl.PrepareForTestExtractorImpl;
import org.powermock.tests.utils.impl.StaticConstructorSuppressExtractorImpl;

public class PowerMockAgentTestInitializer {
    public static void initialize(Class<?> testClass, JavaAgentClassRegister agentClassRegister) {
        MockRepository.clear();
        PowerMockAgentTestInitializer.redefineClasses(testClass, agentClassRegister);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        PowerMockAgentTestInitializer.registerProxyFramework(contextClassLoader);
        new MockPolicyInitializerImpl(testClass).initialize(contextClassLoader);
    }

    private static void redefineClasses(Class<?> testClass, JavaAgentClassRegister agentClassRegister) {
        String[] packagesToIgnore = new PowerMockIgnorePackagesExtractorImpl().getPackagesToIgnore(testClass);
        PowerMockAgentTestInitializer.redefineClassesToPrepare(testClass, packagesToIgnore, agentClassRegister);
        PowerMockAgentTestInitializer.redefineClassesToSuppress(testClass, packagesToIgnore, agentClassRegister);
    }

    private static void redefineClassesToSuppress(Class<?> testClass, String[] packagesToIgnore, JavaAgentClassRegister agentClassRegister) {
        String[] classesToSuppress = new StaticConstructorSuppressExtractorImpl().getTestClasses(testClass);
        PowerMockAgentTestInitializer.redefine(classesToSuppress, packagesToIgnore, agentClassRegister);
    }

    private static void redefineClassesToPrepare(Class<?> testClass, String[] packagesToIgnore, JavaAgentClassRegister agentClassRegister) {
        String[] classesToPrepare = new PrepareForTestExtractorImpl(true).getTestClasses(testClass);
        PowerMockAgentTestInitializer.redefine(classesToPrepare, packagesToIgnore, agentClassRegister);
    }

    private static void redefine(String[] classes, String[] packagesToIgnore, JavaAgentClassRegister agentClassRegister) {
        PowerMockClassRedefiner.redefine(classes, packagesToIgnore, agentClassRegister);
    }

    private static void registerProxyFramework(ClassLoader classLoader) {
        Class<?> proxyFrameworkRegistrar;
        Class<?> proxyFrameworkClass;
        try {
            proxyFrameworkClass = Class.forName("org.powermock.api.extension.proxyframework.ProxyFrameworkImpl", false, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Extension API error: org.powermock.api.extension.proxyframework.ProxyFrameworkImpl could not be located in classpath.");
        }
        try {
            proxyFrameworkRegistrar = Class.forName(RegisterProxyFramework.class.getName(), false, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            Whitebox.invokeMethod(proxyFrameworkRegistrar, (String)"registerProxyFramework", (Object[])new Object[]{Whitebox.newInstance(proxyFrameworkClass)});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

