/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.auctioneer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.Broker;
import org.powertac.common.ClearedTrade;
import org.powertac.common.Competition;
import org.powertac.common.Order;
import org.powertac.common.Orderbook;
import org.powertac.common.OrderbookOrder;
import org.powertac.common.TimeService;
import org.powertac.common.Timeslot;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.interfaces.Accounting;
import org.powertac.common.interfaces.BrokerProxy;
import org.powertac.common.interfaces.InitializationService;
import org.powertac.common.interfaces.ServerConfiguration;
import org.powertac.common.interfaces.TimeslotPhaseProcessor;
import org.powertac.common.msg.OrderStatus;
import org.powertac.common.repo.OrderbookRepo;
import org.powertac.common.repo.TimeslotRepo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuctionService
extends TimeslotPhaseProcessor
implements InitializationService {
    private static Logger log = Logger.getLogger((String)AuctionService.class.getName());
    @Autowired
    private Accounting accountingService;
    @Autowired
    private BrokerProxy brokerProxyService;
    @Autowired
    private TimeService timeService;
    @Autowired
    private TimeslotRepo timeslotRepo;
    @Autowired
    private OrderbookRepo orderbookRepo;
    @Autowired
    private ServerConfiguration serverProps;
    @ConfigurableValue(valueType="Double", publish=true, description="Default margin when matching market order with limit order")
    private double defaultMargin = 0.05;
    @ConfigurableValue(valueType="Double", publish=true, description="Default price/mwh when matching only market orders")
    private double defaultClearingPrice = 40.0;
    @ConfigurableValue(valueType="Double", publish=true, description="Proportion of market surplus allocated to the seller")
    private double sellerSurplusRatio;
    private double epsilon = 1.0E-6;
    private List<Order> incoming = new ArrayList<Order>();
    private HashMap<Timeslot, ArrayList<OrderWrapper>> sortedBids;
    private HashMap<Timeslot, ArrayList<OrderWrapper>> sortedAsks;
    private List<Timeslot> enabledTimeslots = null;

    public String initialize(Competition competition, List<String> completedInits) {
        this.incoming.clear();
        this.serverProps.configureMe((Object)this);
        this.brokerProxyService.registerBrokerMessageListener((Object)this, Order.class);
        super.init();
        this.serverProps.publishConfiguration((Object)this);
        return "Auctioneer";
    }

    public double getSellerSurplusRatio() {
        return this.sellerSurplusRatio;
    }

    public double getDefaultMargin() {
        return this.defaultMargin;
    }

    public double getDefaultClearingPrice() {
        return this.defaultClearingPrice;
    }

    List<Order> getIncoming() {
        return this.incoming;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Order msg) {
        if (this.validateOrder(msg)) {
            List<Order> list = this.incoming;
            synchronized (list) {
                this.incoming.add(msg);
            }
            log.info((Object)("Received " + msg.toString()));
        }
    }

    public boolean validateOrder(Order order) {
        if (order.getMWh().equals(Double.NaN) || order.getMWh().equals(Double.POSITIVE_INFINITY) || order.getMWh().equals(Double.NEGATIVE_INFINITY)) {
            log.warn((Object)("Order from " + order.getBroker().getUsername() + " with invalid quantity " + order.getMWh()));
            return false;
        }
        if (null != order.getLimitPrice() && (order.getLimitPrice().equals(Double.NaN) || order.getLimitPrice().equals(Double.POSITIVE_INFINITY) || order.getLimitPrice().equals(Double.NEGATIVE_INFINITY))) {
            log.warn((Object)("Order from " + order.getBroker().getUsername() + " with invalid price " + order.getLimitPrice()));
            return false;
        }
        double minQuantity = Competition.currentCompetition().getMinimumOrderQuantity();
        if (Math.abs(order.getMWh()) < minQuantity) {
            log.warn((Object)("Order from " + order.getBroker().getUsername() + " with quantity " + order.getMWh() + " < minimum quantity " + minQuantity));
            return false;
        }
        if (!this.timeslotRepo.isTimeslotEnabled(order.getTimeslot())) {
            OrderStatus status = new OrderStatus(order.getBroker(), order.getId());
            this.brokerProxyService.sendMessage(order.getBroker(), (Object)status);
            log.warn((Object)("Order from " + order.getBroker().getUsername() + " for disabled timeslot " + order.getTimeslot()));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(Instant time, int phaseNumber) {
        ArrayList<OrderWrapper> orders;
        log.info((Object)"Activate");
        List<Order> list = this.incoming;
        synchronized (list) {
            orders = new ArrayList<OrderWrapper>();
            for (Order order : this.incoming) {
                OrderWrapper sw = new OrderWrapper(order);
                if (sw.isValid()) {
                    orders.add(new OrderWrapper(order));
                    continue;
                }
                log.info((Object)("Ignoring invalid order " + order.getId() + " from " + order.getBroker().getUsername()));
            }
            this.incoming.clear();
        }
        this.sortedAsks = new HashMap();
        this.sortedBids = new HashMap();
        for (OrderWrapper orderWrapper : orders) {
            if (orderWrapper.isBuyOrder()) {
                this.addBid(orderWrapper);
                continue;
            }
            this.addAsk(orderWrapper);
        }
        for (ArrayList arrayList : this.sortedAsks.values()) {
            Collections.sort(arrayList);
        }
        for (ArrayList arrayList : this.sortedBids.values()) {
            Collections.sort(arrayList);
        }
        log.debug((Object)("activate: asks in " + this.sortedAsks.size() + " timeslots, bids in " + this.sortedBids.size() + " timeslots"));
        if (this.enabledTimeslots == null) {
            this.enabledTimeslots = this.timeslotRepo.enabledTimeslots();
        }
        this.collectAskRanges();
        for (Timeslot timeslot : this.enabledTimeslots) {
            this.clearTimeslot(timeslot);
        }
        this.enabledTimeslots = new ArrayList<Timeslot>(this.timeslotRepo.enabledTimeslots());
    }

    private void clearTimeslot(Timeslot timeslot) {
        List bids = this.sortedBids.get(timeslot);
        List asks = this.sortedAsks.get(timeslot);
        if (bids != null || asks != null) {
            double clearingPrice;
            if (bids != null && asks != null) {
                log.info((Object)("Timeslot " + timeslot.getSerialNumber() + ": Clearing " + asks.size() + " asks and " + bids.size() + " bids"));
            }
            Double bidPrice = 0.0;
            Double askPrice = 0.0;
            double totalMWh = 0.0;
            ArrayList<PendingTrade> pendingTrades = new ArrayList<PendingTrade>();
            while (bids != null && !bids.isEmpty() && asks != null && !asks.isEmpty() && (((OrderWrapper)bids.get(0)).isMarketOrder() || ((OrderWrapper)asks.get(0)).isMarketOrder() || -((OrderWrapper)bids.get(0)).getLimitPrice().doubleValue() >= ((OrderWrapper)asks.get(0)).getLimitPrice())) {
                OrderWrapper bid = (OrderWrapper)bids.get(0);
                bidPrice = bid.getLimitPrice();
                OrderWrapper ask = (OrderWrapper)asks.get(0);
                askPrice = ask.getLimitPrice();
                log.debug((Object)("ask: " + ask.executionMWh + " used out of " + ask.getMWh() + "; bid: " + bid.executionMWh + " used out of " + bid.getMWh()));
                double transfer = Math.min(bid.getMWh() - bid.executionMWh, -ask.getMWh() + ask.executionMWh);
                if (transfer > 0.0) {
                    log.debug((Object)("transfer " + transfer + " from " + ask.getBroker().getUsername() + " at " + askPrice + " to " + bid.getBroker().getUsername() + " at " + bidPrice));
                    totalMWh += transfer;
                    pendingTrades.add(new PendingTrade(ask.getBroker(), bid.getBroker(), transfer));
                    bid.executionMWh += transfer;
                    ask.executionMWh -= transfer;
                }
                log.debug((Object)("bid remaining=" + (bid.getMWh() - bid.executionMWh)));
                log.debug((Object)("ask remaining=" + (ask.getMWh() - ask.executionMWh)));
                if (Math.abs(bid.getMWh() - bid.executionMWh) <= this.epsilon) {
                    bids.remove(bid);
                }
                if (!(Math.abs(ask.getMWh() - ask.executionMWh) <= this.epsilon)) continue;
                asks.remove(ask);
            }
            if (bidPrice != null) {
                if (askPrice != null) {
                    clearingPrice = askPrice + this.sellerSurplusRatio * (-bidPrice.doubleValue() - askPrice);
                } else {
                    clearingPrice = -bidPrice.doubleValue() / (1.0 + this.defaultMargin);
                    log.info((Object)("market clears at " + clearingPrice + " with null ask price"));
                }
            } else if (askPrice != null) {
                clearingPrice = askPrice * (1.0 + this.defaultMargin);
                log.info((Object)("market clears at " + clearingPrice + " with null bid price"));
            } else {
                clearingPrice = this.defaultClearingPrice;
                log.info((Object)("market clears at default clearing price" + clearingPrice));
            }
            for (PendingTrade trade : pendingTrades) {
                this.accountingService.addMarketTransaction(trade.from, timeslot, -trade.mWh, clearingPrice);
                this.accountingService.addMarketTransaction(trade.to, timeslot, trade.mWh, -clearingPrice);
            }
            Orderbook orderbook = this.orderbookRepo.makeOrderbook(timeslot, pendingTrades.size() > 0 ? Double.valueOf(clearingPrice) : null);
            if (bids != null) {
                for (OrderWrapper bid : bids) {
                    orderbook.addBid(new OrderbookOrder(bid.getMWh() - bid.executionMWh, bid.getLimitPrice()));
                }
            }
            if (asks != null) {
                for (OrderWrapper ask : asks) {
                    orderbook.addAsk(new OrderbookOrder(ask.getMWh() - ask.executionMWh, ask.getLimitPrice()));
                }
            }
            this.brokerProxyService.broadcastMessage((Object)orderbook);
            if (totalMWh > 0.0) {
                PendingTrade trade;
                trade = new ClearedTrade(timeslot, totalMWh, clearingPrice, this.timeService.getCurrentTime());
                log.info((Object)trade.toString());
                this.brokerProxyService.broadcastMessage((Object)trade);
            }
        }
    }

    private void addAsk(OrderWrapper marketOrder) {
        Timeslot timeslot = marketOrder.getTimeslot();
        if (this.sortedAsks.get(timeslot) == null) {
            this.sortedAsks.put(timeslot, new ArrayList());
        }
        this.sortedAsks.get(timeslot).add(marketOrder);
    }

    private void addBid(OrderWrapper marketOrder) {
        Timeslot timeslot = marketOrder.getTimeslot();
        if (this.sortedBids.get(timeslot) == null) {
            this.sortedBids.put(timeslot, new ArrayList());
        }
        this.sortedBids.get(timeslot).add(marketOrder);
    }

    private void collectAskRanges() {
        Double[] minPriceArray = new Double[this.enabledTimeslots.size()];
        Double[] maxPriceArray = new Double[this.enabledTimeslots.size()];
        int timeslotIndex = 0;
        for (Timeslot timeslot : this.enabledTimeslots) {
            if (null == this.sortedAsks || null == this.sortedAsks.get(timeslot)) {
                minPriceArray[timeslotIndex] = null;
                maxPriceArray[timeslotIndex] = null;
            } else {
                int lastIndex = this.sortedAsks.get(timeslot).size() - 1;
                OrderWrapper minAsk = this.sortedAsks.get(timeslot).get(0);
                OrderWrapper maxAsk = this.sortedAsks.get(timeslot).get(lastIndex);
                minPriceArray[timeslotIndex] = null == minAsk || minAsk.isMarketOrder() ? null : minAsk.getLimitPrice();
                maxPriceArray[timeslotIndex] = null == maxAsk || maxAsk.isMarketOrder() ? null : maxAsk.getLimitPrice();
            }
            ++timeslotIndex;
        }
        this.orderbookRepo.setMinAskPrices(minPriceArray);
        this.orderbookRepo.setMaxAskPrices(maxPriceArray);
    }

    void clearEnabledTimeslots() {
        this.enabledTimeslots = null;
    }

    private int compareQty(Double thisQty, Double otherQty) {
        return -thisQty.compareTo(otherQty);
    }

    public void setDefaults() {
    }

    class OrderWrapper
    implements Comparable<OrderWrapper> {
        Order order;
        double executionMWh = 0.0;

        OrderWrapper(Order order) {
            this.order = order;
        }

        Broker getBroker() {
            return this.order.getBroker();
        }

        boolean isValid() {
            return this.order.getMWh() != 0.0;
        }

        boolean isMarketOrder() {
            return this.order.getLimitPrice() == null;
        }

        Double getLimitPrice() {
            return this.order.getLimitPrice();
        }

        double getMWh() {
            return this.order.getMWh();
        }

        Timeslot getTimeslot() {
            return this.order.getTimeslot();
        }

        boolean isBuyOrder() {
            return this.order.getMWh() > 0.0;
        }

        @Override
        public int compareTo(OrderWrapper o) {
            OrderWrapper other = o;
            double sign = Math.signum(this.getMWh());
            Double thisQty = sign * this.getMWh();
            Double otherQty = sign * other.getMWh();
            if (this.isMarketOrder()) {
                if (other.isMarketOrder()) {
                    return AuctionService.this.compareQty(thisQty, otherQty);
                }
                return -1;
            }
            if (other.isMarketOrder()) {
                return 1;
            }
            if (this.getLimitPrice().equals(other.getLimitPrice())) {
                return AuctionService.this.compareQty(thisQty, otherQty);
            }
            return this.getLimitPrice() > other.getLimitPrice() ? 1 : -1;
        }

        public boolean equals(OrderWrapper other) {
            if (this.isMarketOrder()) {
                if (other.isMarketOrder()) {
                    return this.getMWh() == other.getMWh();
                }
                return false;
            }
            return this.getLimitPrice().equals(other.getLimitPrice()) && this.getMWh() == other.getMWh();
        }
    }

    class PendingTrade {
        Broker from;
        Broker to;
        double mWh;

        PendingTrade(Broker from, Broker to, double mWh) {
            this.from = from;
            this.to = to;
            this.mWh = mWh;
        }
    }
}

