/*
 * Decompiled with CFR 0.152.
 */
package org.pragmaticminds.crunch.sinks;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import org.pragmaticminds.crunch.api.values.dates.Value;
import org.pragmaticminds.crunch.events.GenericEvent;
import org.pragmaticminds.crunch.execution.EventSink;
import org.pragmaticminds.crunch.serialization.JsonDeserializer;
import org.pragmaticminds.crunch.serialization.JsonSerializer;
import org.pragmaticminds.crunch.sinks.exceptions.UncheckedSQLException;

public class PostgreSqlSink
implements EventSink<GenericEvent>,
Serializable,
AutoCloseable {
    private static final String SQL_INSERT_QUERY = "INSERT INTO events (timestamp, type, source, parameters, raw_data) VALUES (?, ?, ?, ?::JSONB, ?::JSONB)";
    private static final String SQL_CHECK_IF_TABLE_AVAILABLE_QUERY = "SELECT EXISTS (\n   SELECT 1\n   FROM pg_tables \n   WHERE schemaname = 'public'\n   AND tablename = 'events'\n);";
    private static final String SQL_CREATE_EVENTS_TABLE_QUERY = "CREATE TABLE Events (\n  ID         BIGSERIAL NOT NULL PRIMARY KEY,\n  TIMESTAMP  TIMESTAMP,\n  TYPE       VARCHAR(255),\n  SOURCE     VARCHAR(255),\n  PARAMETERS JSONB,\n  RAW_DATA   JSONB\n)";
    private final transient Connection connection;
    private final JsonDeserializer<GenericEvent> deserializer;
    private final transient JsonSerializer<HashMap<String, Value>> parametersSerializer;
    private final transient JsonSerializer<GenericEvent> serializer;

    public PostgreSqlSink(String url, String user, String password) {
        try {
            this.connection = DriverManager.getConnection(url, user, password);
        }
        catch (SQLException ex) {
            throw new UncheckedSQLException("could not establish PostgreSQL connection!", ex);
        }
        this.deserializer = new JsonDeserializer(GenericEvent.class);
        this.parametersSerializer = new JsonSerializer();
        this.serializer = new JsonSerializer();
        if (!this.tableExists()) {
            this.createTable();
        }
    }

    private void createTable() {
        try (Statement statement = this.connection.createStatement();){
            statement.execute(SQL_CREATE_EVENTS_TABLE_QUERY);
        }
        catch (SQLException ex) {
            throw new UncheckedSQLException("could not create EVENTS table on postgres database!", ex);
        }
    }

    /*
     * Exception decompiling
     */
    private boolean tableExists() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void executeCommand(String query) {
        try (Statement statement = this.connection.createStatement();){
            statement.execute(query);
        }
        catch (SQLException ex) {
            throw new UncheckedSQLException(String.format("could not execute query: %s", query), ex);
        }
    }

    /*
     * Exception decompiling
     */
    public List<GenericEvent> executeQuery(String query) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void persist(List<GenericEvent> events) {
        for (GenericEvent event : events) {
            this.handle(event);
        }
    }

    public void handle(GenericEvent event) {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(SQL_INSERT_QUERY);){
            preparedStatement.setTimestamp(1, Timestamp.from(Instant.ofEpochMilli(event.getTimestamp())));
            preparedStatement.setString(2, event.getEventName());
            preparedStatement.setString(3, event.getSource());
            String parameters = new String(this.parametersSerializer.serialize(new HashMap(event.getParameters())));
            preparedStatement.setObject(4, parameters);
            preparedStatement.setObject(5, new String(this.serializer.serialize((Object)event)));
            int executeUpdate = preparedStatement.executeUpdate();
            if (executeUpdate != 1) {
                throw new SQLException(String.format("Did not save the GenericEvent: %s", event));
            }
        }
        catch (SQLException ex) {
            throw new UncheckedSQLException("could not persist Events!", ex);
        }
    }

    @Override
    public void close() {
        try {
            this.connection.close();
        }
        catch (SQLException ex) {
            throw new UncheckedSQLException("could not close PostgreSQL connection!", ex);
        }
    }
}

