/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile.admob;

import com.google.android.gms.ads.AdError;
import org.prebid.mobile.LogUtil;

class AdErrors {
    AdErrors() {
    }

    static AdError emptyResponseId() {
        return AdErrors.createError(1, "Response id is null");
    }

    static AdError notMatchedParameters() {
        return AdErrors.createError(2, "Parameters are different");
    }

    static AdError noResponse(String responseId) {
        return AdErrors.createError(3, "There's no response for the current response id: " + responseId);
    }

    static AdError failedToLoadAd(String error) {
        String message = "Failed to load ad: " + error;
        LogUtil.error((String)"PrebidAdapter", (String)message);
        return AdErrors.createError(4, message);
    }

    static AdError emptyPrebidKeywords() {
        return AdErrors.createError(5, "Prebid keywords are empty");
    }

    static AdError interstitialControllerError(String error) {
        String message = "Exception in Prebid interstitial controller: " + error;
        LogUtil.error((String)"PrebidAdapter", (String)message);
        return AdErrors.createError(6, message);
    }

    static AdError emptyNativeCacheId() {
        return AdErrors.createError(7, "Empty native ad unit cache id");
    }

    static AdError prebidNativeAdIsNull() {
        return AdErrors.createError(8, "PrebidNativeAd is null");
    }

    private static AdError createError(int code, String message) {
        return new AdError(code, message, "prebid");
    }
}

