/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile.admob;

import android.os.Bundle;
import android.util.Log;
import android.view.View;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.AdView;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import org.prebid.mobile.LogUtil;
import org.prebid.mobile.rendering.bidding.data.bid.BidResponse;
import org.prebid.mobile.rendering.bidding.display.PrebidMediationDelegate;
import org.prebid.mobile.rendering.models.internal.VisibilityTrackerOption;
import org.prebid.mobile.rendering.models.ntv.NativeEventTracker;
import org.prebid.mobile.rendering.utils.helpers.VisibilityChecker;

public class AdMobMediationBannerUtils
implements PrebidMediationDelegate {
    private static final String TAG = "BannerMediationUtils";
    private final Bundle extras;
    private final WeakReference<AdView> adView;

    public AdMobMediationBannerUtils(Bundle adMobExtrasBundle, AdView adView) {
        this.extras = adMobExtrasBundle;
        this.adView = new WeakReference<AdView>(adView);
    }

    public void setResponseToLocalExtras(@Nullable BidResponse response) {
        if (response != null) {
            this.extras.putString("PrebidBannerAdapterExtraId", response.getId());
        }
    }

    public boolean canPerformRefresh() {
        AdView view = (AdView)this.adView.get();
        if (view == null) {
            LogUtil.error((String)TAG, (String)"AdView is null, it can be destroyed as WeakReference");
            return false;
        }
        VisibilityTrackerOption visibilityTrackerOption = new VisibilityTrackerOption(NativeEventTracker.EventType.IMPRESSION);
        VisibilityChecker checker = new VisibilityChecker(visibilityTrackerOption);
        boolean isVisible = checker.isVisibleForRefresh((View)view);
        if (isVisible) {
            Log.d((String)TAG, (String)"Visibility checker result: true");
        } else {
            Log.e((String)TAG, (String)"Can't perform refresh. Ad view is not visible.");
        }
        return isVisible;
    }

    public void handleKeywordsUpdate(@Nullable HashMap<String, String> keywords) {
    }
}

