/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile.admob;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.mediation.MediationAdConfiguration;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationInterstitialAd;
import com.google.android.gms.ads.mediation.MediationInterstitialAdCallback;
import com.google.android.gms.ads.mediation.MediationInterstitialAdConfiguration;
import org.prebid.mobile.admob.AdErrors;
import org.prebid.mobile.admob.PrebidBaseAdapter;
import org.prebid.mobile.api.exceptions.AdException;
import org.prebid.mobile.rendering.bidding.display.InterstitialController;
import org.prebid.mobile.rendering.bidding.interfaces.InterstitialControllerListener;

public class PrebidInterstitialAdapter
extends PrebidBaseAdapter {
    public static final String EXTRA_RESPONSE_ID = "PrebidInterstitialAdapterExtraId";
    @Nullable
    private InterstitialController interstitialController;
    @Nullable
    private MediationInterstitialAdCallback adMobInterstitialListener;

    public void loadInterstitialAd(@NonNull MediationInterstitialAdConfiguration configuration, @NonNull MediationAdLoadCallback<MediationInterstitialAd, MediationInterstitialAdCallback> adMobLoadListener) {
        String responseId = this.getResponseIdAndCheckParameters((MediationAdConfiguration)configuration, EXTRA_RESPONSE_ID, arg_0 -> adMobLoadListener.onFailure(arg_0));
        if (responseId == null) {
            return;
        }
        try {
            InterstitialControllerListener listener = this.getListener(adMobLoadListener);
            this.interstitialController = new InterstitialController(configuration.getContext(), listener);
            this.interstitialController.loadAd(responseId, false);
        }
        catch (AdException e) {
            adMobLoadListener.onFailure(AdErrors.interstitialControllerError(e.getMessage()));
        }
    }

    private InterstitialControllerListener getListener(final MediationAdLoadCallback<MediationInterstitialAd, MediationInterstitialAdCallback> loadListener) {
        return new InterstitialControllerListener(){

            public void onInterstitialReadyForDisplay() {
                PrebidInterstitialAdapter.this.adMobInterstitialListener = (MediationInterstitialAdCallback)loadListener.onSuccess(context -> {
                    if (PrebidInterstitialAdapter.this.interstitialController != null) {
                        PrebidInterstitialAdapter.this.interstitialController.show();
                    }
                });
            }

            public void onInterstitialDisplayed() {
                if (PrebidInterstitialAdapter.this.adMobInterstitialListener != null) {
                    PrebidInterstitialAdapter.this.adMobInterstitialListener.reportAdImpression();
                    PrebidInterstitialAdapter.this.adMobInterstitialListener.onAdOpened();
                }
            }

            public void onInterstitialClicked() {
                if (PrebidInterstitialAdapter.this.adMobInterstitialListener != null) {
                    PrebidInterstitialAdapter.this.adMobInterstitialListener.reportAdClicked();
                }
            }

            public void onInterstitialClosed() {
                if (PrebidInterstitialAdapter.this.adMobInterstitialListener != null) {
                    PrebidInterstitialAdapter.this.adMobInterstitialListener.onAdClosed();
                }
            }

            public void onInterstitialFailedToLoad(AdException exception) {
                loadListener.onFailure(AdErrors.failedToLoadAd(exception.getMessage()));
            }
        };
    }
}

