/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.integrationtests.autocomplete;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.primefaces.integrationtests.general.model.Driver;
import org.primefaces.integrationtests.general.service.GeneratedDriverService;
import org.primefaces.integrationtests.general.utilities.TestUtils;

@Named
@ViewScoped
public class AutoComplete006
implements Serializable {
    private static final long serialVersionUID = -7518459955779385834L;
    @Inject
    private GeneratedDriverService service;
    private Driver driver;

    @PostConstruct
    public void init() {
        this.driver = (Driver)this.service.getDrivers().get(4);
    }

    public void submit() {
        if (this.driver != null) {
            FacesMessage msg = new FacesMessage("Driver", "id: " + this.driver.getId() + ", name: " + this.driver.getName());
            FacesContext.getCurrentInstance().addMessage(null, msg);
        }
    }

    public List<Driver> completeText(String query) {
        TestUtils.wait((int)2000);
        return this.service.getDrivers().stream().filter(d -> d.getName().contains(query)).collect(Collectors.toList());
    }

    public GeneratedDriverService getService() {
        return this.service;
    }

    public Driver getDriver() {
        return this.driver;
    }

    public void setService(GeneratedDriverService service) {
        this.service = service;
    }

    public void setDriver(Driver driver) {
        this.driver = driver;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoComplete006)) {
            return false;
        }
        AutoComplete006 other = (AutoComplete006)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        GeneratedDriverService this$service = this.getService();
        GeneratedDriverService other$service = other.getService();
        if (this$service == null ? other$service != null : !this$service.equals(other$service)) {
            return false;
        }
        Driver this$driver = this.getDriver();
        Driver other$driver = other.getDriver();
        return !(this$driver == null ? other$driver != null : !this$driver.equals(other$driver));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AutoComplete006;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GeneratedDriverService $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        Driver $driver = this.getDriver();
        result = result * 59 + ($driver == null ? 43 : $driver.hashCode());
        return result;
    }

    public String toString() {
        return "AutoComplete006(service=" + this.getService() + ", driver=" + this.getDriver() + ")";
    }
}

