/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.integrationtests.colorpicker;

import java.io.Serializable;
import javax.annotation.PostConstruct;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.view.ViewScoped;
import javax.inject.Named;
import org.primefaces.component.colorpicker.ColorPicker;
import org.primefaces.integrationtests.general.utilities.TestUtils;

@Named
@ViewScoped
public class ColorPicker001
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String color;
    private String ajax;
    private String openclose;

    @PostConstruct
    public void init() {
        this.color = "#2a9d8f";
        this.ajax = "#e9c46a";
        this.openclose = "#d62828";
    }

    public void submit() {
        TestUtils.addMessage((String)"Color Saved", (String)this.getColor());
    }

    public void onColorChange(AjaxBehaviorEvent e) {
        ColorPicker picker = (ColorPicker)e.getComponent();
        TestUtils.addMessage((String)"Color Changed", (String)String.valueOf(picker.getValue()));
    }

    public void onPopupClosed(AjaxBehaviorEvent e) {
        ColorPicker picker = (ColorPicker)e.getComponent();
        TestUtils.addMessage((String)"Popup Closed", (String)String.valueOf(picker.getValue()));
    }

    public void onPopupOpened(AjaxBehaviorEvent e) {
        ColorPicker picker = (ColorPicker)e.getComponent();
        TestUtils.addMessage((String)"Popup Opened", (String)String.valueOf(picker.getValue()));
    }

    public String getColor() {
        return this.color;
    }

    public String getAjax() {
        return this.ajax;
    }

    public String getOpenclose() {
        return this.openclose;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setAjax(String ajax) {
        this.ajax = ajax;
    }

    public void setOpenclose(String openclose) {
        this.openclose = openclose;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColorPicker001)) {
            return false;
        }
        ColorPicker001 other = (ColorPicker001)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$color = this.getColor();
        String other$color = other.getColor();
        if (this$color == null ? other$color != null : !this$color.equals(other$color)) {
            return false;
        }
        String this$ajax = this.getAjax();
        String other$ajax = other.getAjax();
        if (this$ajax == null ? other$ajax != null : !this$ajax.equals(other$ajax)) {
            return false;
        }
        String this$openclose = this.getOpenclose();
        String other$openclose = other.getOpenclose();
        return !(this$openclose == null ? other$openclose != null : !this$openclose.equals(other$openclose));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ColorPicker001;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : $color.hashCode());
        String $ajax = this.getAjax();
        result = result * 59 + ($ajax == null ? 43 : $ajax.hashCode());
        String $openclose = this.getOpenclose();
        result = result * 59 + ($openclose == null ? 43 : $openclose.hashCode());
        return result;
    }

    public String toString() {
        return "ColorPicker001(color=" + this.getColor() + ", ajax=" + this.getAjax() + ", openclose=" + this.getOpenclose() + ")";
    }
}

