/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.integrationtests.datatable;

import java.lang.reflect.Field;
import java.util.Comparator;
import org.primefaces.integrationtests.datatable.Customer;
import org.primefaces.model.SortOrder;

public class CustomerLazySorter
implements Comparator<Customer> {
    private String sortField;
    private SortOrder sortOrder;

    public CustomerLazySorter(String sortField, SortOrder sortOrder) {
        this.sortField = sortField;
        this.sortOrder = sortOrder;
    }

    @Override
    public int compare(Customer customer1, Customer customer2) {
        try {
            Field field = this.getCustomerField(this.sortField);
            Object value1 = field.get(customer1);
            Object value2 = field.get(customer2);
            int value = ((Comparable)value1).compareTo(value2);
            return SortOrder.ASCENDING.equals((Object)this.sortOrder) ? value : -1 * value;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Field getCustomerField(String name) throws NoSuchFieldException {
        Field field = Customer.class.getDeclaredField(name);
        field.setAccessible(true);
        return field;
    }
}

