/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.integrationtests.datatable;

import java.io.Serializable;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.integrationtests.datatable.ProgrammingLanguage;
import org.primefaces.integrationtests.datatable.ProgrammingLanguageService;
import org.primefaces.model.DefaultLazyDataModel;
import org.primefaces.model.LazyDataModel;
import org.primefaces.util.Callbacks;

@Named
@ViewScoped
public class DataTable001
implements Serializable {
    private static final long serialVersionUID = -7518459955779385834L;
    private List<ProgrammingLanguage> progLanguages;
    private LazyDataModel<ProgrammingLanguage> progLanguagesLazyDataModel;
    private List<ProgrammingLanguage> filteredProgLanguages;
    private boolean globalFilterOnly;
    private int rows = 3;
    @Inject
    private ProgrammingLanguageService service;

    @PostConstruct
    public void init() {
        this.progLanguages = this.service.getLangs();
        this.progLanguagesLazyDataModel = DefaultLazyDataModel.builder().valueSupplier((Callbacks.SerializableSupplier & Serializable)() -> this.service.getLangs()).rowKeyProvider(ProgrammingLanguage::getId).build();
        this.globalFilterOnly = false;
    }

    public void resetTable() {
        DataTable dataTable = (DataTable)FacesContext.getCurrentInstance().getViewRoot().findComponent("form:datatable");
        dataTable.reset();
        this.progLanguages = this.service.getLangs();
    }

    public void toggleGlobalFilter() {
        this.setGlobalFilterOnly(!this.isGlobalFilterOnly());
    }

    public List<ProgrammingLanguage> getProgLanguages() {
        return this.progLanguages;
    }

    public LazyDataModel<ProgrammingLanguage> getProgLanguagesLazyDataModel() {
        return this.progLanguagesLazyDataModel;
    }

    public List<ProgrammingLanguage> getFilteredProgLanguages() {
        return this.filteredProgLanguages;
    }

    public boolean isGlobalFilterOnly() {
        return this.globalFilterOnly;
    }

    public int getRows() {
        return this.rows;
    }

    public ProgrammingLanguageService getService() {
        return this.service;
    }

    public void setProgLanguages(List<ProgrammingLanguage> progLanguages) {
        this.progLanguages = progLanguages;
    }

    public void setProgLanguagesLazyDataModel(LazyDataModel<ProgrammingLanguage> progLanguagesLazyDataModel) {
        this.progLanguagesLazyDataModel = progLanguagesLazyDataModel;
    }

    public void setFilteredProgLanguages(List<ProgrammingLanguage> filteredProgLanguages) {
        this.filteredProgLanguages = filteredProgLanguages;
    }

    public void setGlobalFilterOnly(boolean globalFilterOnly) {
        this.globalFilterOnly = globalFilterOnly;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public void setService(ProgrammingLanguageService service) {
        this.service = service;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataTable001)) {
            return false;
        }
        DataTable001 other = (DataTable001)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isGlobalFilterOnly() != other.isGlobalFilterOnly()) {
            return false;
        }
        if (this.getRows() != other.getRows()) {
            return false;
        }
        List this$progLanguages = this.getProgLanguages();
        List other$progLanguages = other.getProgLanguages();
        if (this$progLanguages == null ? other$progLanguages != null : !((Object)this$progLanguages).equals(other$progLanguages)) {
            return false;
        }
        LazyDataModel this$progLanguagesLazyDataModel = this.getProgLanguagesLazyDataModel();
        LazyDataModel other$progLanguagesLazyDataModel = other.getProgLanguagesLazyDataModel();
        if (this$progLanguagesLazyDataModel == null ? other$progLanguagesLazyDataModel != null : !this$progLanguagesLazyDataModel.equals(other$progLanguagesLazyDataModel)) {
            return false;
        }
        List this$filteredProgLanguages = this.getFilteredProgLanguages();
        List other$filteredProgLanguages = other.getFilteredProgLanguages();
        if (this$filteredProgLanguages == null ? other$filteredProgLanguages != null : !((Object)this$filteredProgLanguages).equals(other$filteredProgLanguages)) {
            return false;
        }
        ProgrammingLanguageService this$service = this.getService();
        ProgrammingLanguageService other$service = other.getService();
        return !(this$service == null ? other$service != null : !this$service.equals(other$service));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataTable001;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isGlobalFilterOnly() ? 79 : 97);
        result = result * 59 + this.getRows();
        List $progLanguages = this.getProgLanguages();
        result = result * 59 + ($progLanguages == null ? 43 : ((Object)$progLanguages).hashCode());
        LazyDataModel $progLanguagesLazyDataModel = this.getProgLanguagesLazyDataModel();
        result = result * 59 + ($progLanguagesLazyDataModel == null ? 43 : $progLanguagesLazyDataModel.hashCode());
        List $filteredProgLanguages = this.getFilteredProgLanguages();
        result = result * 59 + ($filteredProgLanguages == null ? 43 : ((Object)$filteredProgLanguages).hashCode());
        ProgrammingLanguageService $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        return result;
    }

    public String toString() {
        return "DataTable001(progLanguages=" + this.getProgLanguages() + ", progLanguagesLazyDataModel=" + this.getProgLanguagesLazyDataModel() + ", filteredProgLanguages=" + this.getFilteredProgLanguages() + ", globalFilterOnly=" + this.isGlobalFilterOnly() + ", rows=" + this.getRows() + ", service=" + this.getService() + ")";
    }
}

