/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.integrationtests.datatable;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.faces.view.ViewScoped;
import javax.inject.Named;
import org.primefaces.event.SelectEvent;
import org.primefaces.integrationtests.datatable.ProgrammingLanguage;
import org.primefaces.integrationtests.datatable.ProgrammingLanguageLazyDataModel;
import org.primefaces.integrationtests.general.utilities.TestUtils;
import org.primefaces.model.DefaultLazyDataModel;
import org.primefaces.util.Callbacks;

@Named
@ViewScoped
public class DataTable002
implements Serializable {
    private static final long serialVersionUID = -7518459955779385834L;
    protected List<ProgrammingLanguage> programmingLanguages;
    protected ProgrammingLanguageLazyDataModel lazyDataModel;
    protected DefaultLazyDataModel<ProgrammingLanguage> reflectionLazyDataModel;
    protected ProgrammingLanguage selectedProgrammingLanguage;

    @PostConstruct
    public void init() {
        this.programmingLanguages = new ArrayList();
        for (int i = 1; i <= 75; ++i) {
            this.programmingLanguages.add(new ProgrammingLanguage(Integer.valueOf(i), "Language " + i, Integer.valueOf(1990 + i % 10), i % 2 == 0 ? ProgrammingLanguage.ProgrammingLanguageType.COMPILED : ProgrammingLanguage.ProgrammingLanguageType.INTERPRETED));
        }
        this.lazyDataModel = new ProgrammingLanguageLazyDataModel();
        this.reflectionLazyDataModel = DefaultLazyDataModel.builder().valueSupplier((Callbacks.SerializableSupplier & Serializable)() -> this.programmingLanguages).rowKeyProvider(ProgrammingLanguage::getId).build();
    }

    public void onRowSelect(SelectEvent<ProgrammingLanguage> event) {
        TestUtils.addMessage((String)"ProgrammingLanguage Selected", (String)(((ProgrammingLanguage)event.getObject()).getId() + " - " + ((ProgrammingLanguage)event.getObject()).getName()));
    }

    public void delete(ProgrammingLanguage language) {
        this.lazyDataModel.delete(language);
        if (this.programmingLanguages != null) {
            this.programmingLanguages.remove(language);
        }
        TestUtils.addMessage((String)"ProgrammingLanguage Deleted", (String)(language.getId() + " - " + language.getName()));
    }

    public void submit() {
        if (this.selectedProgrammingLanguage != null) {
            TestUtils.addMessage((String)"Selected ProgrammingLanguage", (String)this.selectedProgrammingLanguage.getId().toString());
        }
    }

    public ProgrammingLanguage.ProgrammingLanguageType[] getTypes() {
        return ProgrammingLanguage.ProgrammingLanguageType.values();
    }

    public List<ProgrammingLanguage> getProgrammingLanguages() {
        return this.programmingLanguages;
    }

    public ProgrammingLanguageLazyDataModel getLazyDataModel() {
        return this.lazyDataModel;
    }

    public DefaultLazyDataModel<ProgrammingLanguage> getReflectionLazyDataModel() {
        return this.reflectionLazyDataModel;
    }

    public ProgrammingLanguage getSelectedProgrammingLanguage() {
        return this.selectedProgrammingLanguage;
    }

    public void setProgrammingLanguages(List<ProgrammingLanguage> programmingLanguages) {
        this.programmingLanguages = programmingLanguages;
    }

    public void setLazyDataModel(ProgrammingLanguageLazyDataModel lazyDataModel) {
        this.lazyDataModel = lazyDataModel;
    }

    public void setReflectionLazyDataModel(DefaultLazyDataModel<ProgrammingLanguage> reflectionLazyDataModel) {
        this.reflectionLazyDataModel = reflectionLazyDataModel;
    }

    public void setSelectedProgrammingLanguage(ProgrammingLanguage selectedProgrammingLanguage) {
        this.selectedProgrammingLanguage = selectedProgrammingLanguage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataTable002)) {
            return false;
        }
        DataTable002 other = (DataTable002)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List this$programmingLanguages = this.getProgrammingLanguages();
        List other$programmingLanguages = other.getProgrammingLanguages();
        if (this$programmingLanguages == null ? other$programmingLanguages != null : !((Object)this$programmingLanguages).equals(other$programmingLanguages)) {
            return false;
        }
        ProgrammingLanguageLazyDataModel this$lazyDataModel = this.getLazyDataModel();
        ProgrammingLanguageLazyDataModel other$lazyDataModel = other.getLazyDataModel();
        if (this$lazyDataModel == null ? other$lazyDataModel != null : !this$lazyDataModel.equals(other$lazyDataModel)) {
            return false;
        }
        DefaultLazyDataModel this$reflectionLazyDataModel = this.getReflectionLazyDataModel();
        DefaultLazyDataModel other$reflectionLazyDataModel = other.getReflectionLazyDataModel();
        if (this$reflectionLazyDataModel == null ? other$reflectionLazyDataModel != null : !this$reflectionLazyDataModel.equals(other$reflectionLazyDataModel)) {
            return false;
        }
        ProgrammingLanguage this$selectedProgrammingLanguage = this.getSelectedProgrammingLanguage();
        ProgrammingLanguage other$selectedProgrammingLanguage = other.getSelectedProgrammingLanguage();
        return !(this$selectedProgrammingLanguage == null ? other$selectedProgrammingLanguage != null : !this$selectedProgrammingLanguage.equals(other$selectedProgrammingLanguage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataTable002;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List $programmingLanguages = this.getProgrammingLanguages();
        result = result * 59 + ($programmingLanguages == null ? 43 : ((Object)$programmingLanguages).hashCode());
        ProgrammingLanguageLazyDataModel $lazyDataModel = this.getLazyDataModel();
        result = result * 59 + ($lazyDataModel == null ? 43 : $lazyDataModel.hashCode());
        DefaultLazyDataModel $reflectionLazyDataModel = this.getReflectionLazyDataModel();
        result = result * 59 + ($reflectionLazyDataModel == null ? 43 : $reflectionLazyDataModel.hashCode());
        ProgrammingLanguage $selectedProgrammingLanguage = this.getSelectedProgrammingLanguage();
        result = result * 59 + ($selectedProgrammingLanguage == null ? 43 : $selectedProgrammingLanguage.hashCode());
        return result;
    }

    public String toString() {
        return "DataTable002(programmingLanguages=" + this.getProgrammingLanguages() + ", lazyDataModel=" + this.getLazyDataModel() + ", reflectionLazyDataModel=" + this.getReflectionLazyDataModel() + ", selectedProgrammingLanguage=" + this.getSelectedProgrammingLanguage() + ")";
    }
}

