/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.integrationtests.datatable;

import java.io.Serializable;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.faces.view.ViewScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.primefaces.integrationtests.datatable.Customer;
import org.primefaces.integrationtests.datatable.CustomerLazyDataModelNoCountImpl;
import org.primefaces.integrationtests.datatable.CustomerService;
import org.primefaces.model.LazyDataModel;

@Named
@ViewScoped
public class DataTable045
implements Serializable {
    private static final long serialVersionUID = -7518459955779385834L;
    private List<Customer> customers;
    private LazyDataModel<Customer> lazyModel;
    @Inject
    private CustomerService service;

    @PostConstruct
    public void init() {
        this.customers = this.service.getCustomers();
        this.lazyModel = new CustomerLazyDataModelNoCountImpl(this.customers);
    }

    public LazyDataModel<Customer> getLazyModel() {
        return this.lazyModel;
    }

    public long getTotalCount(String name) {
        return this.customers.stream().filter(customer -> name.equals(customer.getRepresentative())).count();
    }

    public List<Customer> getCustomers() {
        return this.customers;
    }

    public CustomerService getService() {
        return this.service;
    }

    public void setCustomers(List<Customer> customers) {
        this.customers = customers;
    }

    public void setLazyModel(LazyDataModel<Customer> lazyModel) {
        this.lazyModel = lazyModel;
    }

    public void setService(CustomerService service) {
        this.service = service;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataTable045)) {
            return false;
        }
        DataTable045 other = (DataTable045)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List this$customers = this.getCustomers();
        List other$customers = other.getCustomers();
        if (this$customers == null ? other$customers != null : !((Object)this$customers).equals(other$customers)) {
            return false;
        }
        LazyDataModel this$lazyModel = this.getLazyModel();
        LazyDataModel other$lazyModel = other.getLazyModel();
        if (this$lazyModel == null ? other$lazyModel != null : !this$lazyModel.equals(other$lazyModel)) {
            return false;
        }
        CustomerService this$service = this.getService();
        CustomerService other$service = other.getService();
        return !(this$service == null ? other$service != null : !this$service.equals(other$service));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataTable045;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List $customers = this.getCustomers();
        result = result * 59 + ($customers == null ? 43 : ((Object)$customers).hashCode());
        LazyDataModel $lazyModel = this.getLazyModel();
        result = result * 59 + ($lazyModel == null ? 43 : $lazyModel.hashCode());
        CustomerService $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        return result;
    }

    public String toString() {
        return "DataTable045(customers=" + this.getCustomers() + ", lazyModel=" + this.getLazyModel() + ", service=" + this.getService() + ")";
    }
}

