/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.integrationtests.menubar;

import java.io.Serializable;
import javax.annotation.PostConstruct;
import javax.faces.view.ViewScoped;
import javax.inject.Named;
import org.primefaces.integrationtests.general.utilities.TestUtils;
import org.primefaces.model.menu.DefaultMenuItem;
import org.primefaces.model.menu.DefaultMenuModel;
import org.primefaces.model.menu.DefaultSubMenu;
import org.primefaces.model.menu.MenuModel;

@Named
@ViewScoped
public class MenuBar002
implements Serializable {
    private static final long serialVersionUID = 5366641524856531279L;
    private MenuModel model;

    @PostConstruct
    public void init() {
        this.model = new DefaultMenuModel();
        DefaultSubMenu firstSubmenu = DefaultSubMenu.builder().label("Options").build();
        DefaultMenuItem item = DefaultMenuItem.builder().value((Object)"Save (Non-Ajax)").icon("pi pi-save").ajax(false).command("#{menuBar002.save}").update("msgs").build();
        firstSubmenu.getElements().add(item);
        item = DefaultMenuItem.builder().value((Object)"Update").icon("pi pi-refresh").command("#{menuBar002.update}").update("msgs").build();
        firstSubmenu.getElements().add(item);
        item = DefaultMenuItem.builder().value((Object)"Delete").icon("pi pi-times").command("#{menuBar002.delete}").update("msgs").build();
        firstSubmenu.getElements().add(item);
        this.model.getElements().add(firstSubmenu);
        DefaultSubMenu secondSubmenu = DefaultSubMenu.builder().label("Navigations").build();
        item = DefaultMenuItem.builder().value((Object)"Website").url("http://www.primefaces.org").icon("pi pi-external-link").build();
        secondSubmenu.getElements().add(item);
        item = DefaultMenuItem.builder().value((Object)"Internal").icon("pi pi-upload").command("#{menuBar002.redirect}").build();
        secondSubmenu.getElements().add(item);
        this.model.getElements().add(secondSubmenu);
    }

    public void save() {
        TestUtils.addMessage((String)"Save", (String)"Data saved");
    }

    public void update() {
        TestUtils.addMessage((String)"Update", (String)"Data updated");
    }

    public void delete() {
        TestUtils.addMessage((String)"Delete", (String)"Data deleted");
    }

    public MenuModel getModel() {
        return this.model;
    }

    public void setModel(MenuModel model) {
        this.model = model;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MenuBar002)) {
            return false;
        }
        MenuBar002 other = (MenuBar002)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        MenuModel this$model = this.getModel();
        MenuModel other$model = other.getModel();
        return !(this$model == null ? other$model != null : !this$model.equals(other$model));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MenuBar002;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MenuModel $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        return result;
    }

    public String toString() {
        return "MenuBar002(model=" + this.getModel() + ")";
    }
}

