/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.integrationtests.treetable;

import java.io.Serializable;
import javax.annotation.PostConstruct;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.primefaces.component.treetable.TreeTable;
import org.primefaces.event.RowEditEvent;
import org.primefaces.integrationtests.general.utilities.TestUtils;
import org.primefaces.integrationtests.treetable.Document;
import org.primefaces.integrationtests.treetable.DocumentService;
import org.primefaces.model.TreeNode;

@Named
@ViewScoped
public class TreeTable006
implements Serializable {
    private static final long serialVersionUID = -1770454688771221867L;
    private TreeNode<Document> root;
    private Document selectedDocument;
    @Inject
    private DocumentService service;

    @PostConstruct
    public void init() {
        this.root = this.service.createDocuments();
    }

    public void resetTable() {
        TreeTable treeTable = (TreeTable)FacesContext.getCurrentInstance().getViewRoot().findComponent("form:treeTable");
        treeTable.reset();
        this.init();
    }

    public void showSelectedDocument() {
        TestUtils.addMessage((String)"selected document", (String)(this.selectedDocument.getName() + ";" + this.selectedDocument.getSize() + ";" + this.selectedDocument.getType()));
    }

    public void onRowEdit(RowEditEvent<TreeNode<Document>> event) {
        TestUtils.addMessage((String)"Document Edited", (String)((TreeNode)event.getObject()).toString());
    }

    public void onRowCancel(RowEditEvent<TreeNode<Document>> event) {
        TestUtils.addMessage((String)"Edit Cancelled", (String)((TreeNode)event.getObject()).toString());
    }

    public TreeNode<Document> getRoot() {
        return this.root;
    }

    public Document getSelectedDocument() {
        return this.selectedDocument;
    }

    public DocumentService getService() {
        return this.service;
    }

    public void setRoot(TreeNode<Document> root) {
        this.root = root;
    }

    public void setSelectedDocument(Document selectedDocument) {
        this.selectedDocument = selectedDocument;
    }

    public void setService(DocumentService service) {
        this.service = service;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TreeTable006)) {
            return false;
        }
        TreeTable006 other = (TreeTable006)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        TreeNode this$root = this.getRoot();
        TreeNode other$root = other.getRoot();
        if (this$root == null ? other$root != null : !this$root.equals(other$root)) {
            return false;
        }
        Document this$selectedDocument = this.getSelectedDocument();
        Document other$selectedDocument = other.getSelectedDocument();
        if (this$selectedDocument == null ? other$selectedDocument != null : !this$selectedDocument.equals(other$selectedDocument)) {
            return false;
        }
        DocumentService this$service = this.getService();
        DocumentService other$service = other.getService();
        return !(this$service == null ? other$service != null : !this$service.equals(other$service));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TreeTable006;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TreeNode $root = this.getRoot();
        result = result * 59 + ($root == null ? 43 : $root.hashCode());
        Document $selectedDocument = this.getSelectedDocument();
        result = result * 59 + ($selectedDocument == null ? 43 : $selectedDocument.hashCode());
        DocumentService $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        return result;
    }

    public String toString() {
        return "TreeTable006(root=" + this.getRoot() + ", selectedDocument=" + this.getSelectedDocument() + ", service=" + this.getService() + ")";
    }
}

