/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.ch.ppq.hl7v3;

import org.projecthusky.xua.hl7v3.CE;
import org.projecthusky.xua.hl7v3.impl.CodedWithEquivalentsBuilder;

public interface RoleChImpl {
    public static final String CODE_SYSTEM_NAME = "eHealth Suisse EPR Akteure";
    public static final String CODE_SYSTEM = "2.16.756.5.30.1.127.3.10.6";
    public static final String CODE_ASS = "ASS";
    public static final String CODE_DADM = "DADM";
    public static final String CODE_HCP = "HCP";
    public static final String CODE_PAT = "PAT";
    public static final String CODE_PADM = "PADM";
    public static final String CODE_REP = "REP";
    public static final String CODE_TCU = "TCU";

    public static CE assistent() {
        return RoleChImpl.generateRole(CODE_ASS, "Assistent");
    }

    public static CE documentAdministrator() {
        return RoleChImpl.generateRole(CODE_DADM, "Document Administrator");
    }

    private static CE generateRole(String code, String displayName) {
        return new CodedWithEquivalentsBuilder().code(code).codeSystem(CODE_SYSTEM).codeSystemName(CODE_SYSTEM_NAME).displayName(displayName).buildObject("urn:hl7-org:v3", "Role", "hl7");
    }

    public static CE healthCareProfessional() {
        return RoleChImpl.generateRole(CODE_HCP, "Behandelnde(r)");
    }

    public static CE patient() {
        return RoleChImpl.generateRole(CODE_PAT, "Patient");
    }

    public static CE policyAdministrator() {
        return RoleChImpl.generateRole(CODE_PADM, "Policy Administrator");
    }

    public static CE representative() {
        return RoleChImpl.generateRole(CODE_REP, "Representative");
    }

    public static CE technicalUser() {
        return RoleChImpl.generateRole(CODE_TCU, "Technical user");
    }
}

