/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.ch.ppq.impl;

import java.util.Calendar;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.xacml.ctx.AttributeType;
import org.opensaml.xacml.ctx.AttributeValueType;
import org.opensaml.xacml.ctx.RequestType;
import org.opensaml.xacml.ctx.ResourceType;
import org.opensaml.xacml.profile.saml.XACMLPolicyQueryType;
import org.projecthusky.communication.ch.ppq.api.PrivacyPolicyQuery;
import org.projecthusky.xua.core.SecurityObject;
import org.projecthusky.xua.hl7v3.InstanceIdentifier;

public class PrivacyPolicyQueryImpl
implements PrivacyPolicyQuery,
SecurityObject<XACMLPolicyQueryType> {
    private XACMLPolicyQueryType internalObject;

    protected PrivacyPolicyQueryImpl(XACMLPolicyQueryType aInternalObject) {
        this.internalObject = aInternalObject;
    }

    @Override
    public String getConsent() {
        if (this.internalObject.getConsent() != null) {
            return this.internalObject.getConsent();
        }
        return "";
    }

    @Override
    public String getDestination() {
        return this.internalObject.getDestination();
    }

    public String getId() {
        return this.internalObject.getID();
    }

    @Override
    public InstanceIdentifier getInstanceIdentifier() {
        for (RequestType request : this.internalObject.getRequests()) {
            for (ResourceType resource : request.getResources()) {
                for (AttributeType attribute : resource.getAttributes()) {
                    InstanceIdentifier instanceIdent = this.extractEprSpidFromAttributes(attribute);
                    if (instanceIdent == null) continue;
                    return instanceIdent;
                }
            }
        }
        return null;
    }

    private InstanceIdentifier extractEprSpidFromAttributes(AttributeType attribute) {
        if ("urn:e-health-suisse:2015:epr-spid".equalsIgnoreCase(attribute.getAttributeId())) {
            for (AttributeValueType attVal : attribute.getAttributeValues()) {
                for (XMLObject value : attVal.getUnknownXMLObjects()) {
                    if (!(value instanceof InstanceIdentifier)) continue;
                    InstanceIdentifier retVal = (InstanceIdentifier)value;
                    return retVal;
                }
            }
        }
        return null;
    }

    public Calendar getIssueInstant() {
        Calendar retVal = Calendar.getInstance();
        retVal.setTimeInMillis(this.internalObject.getIssueInstant().toEpochMilli());
        return retVal;
    }

    public String getIssuer() {
        return this.internalObject.getIssuer().getValue();
    }

    public String getVersion() {
        if (this.internalObject.getVersion() != null) {
            return this.internalObject.getVersion().toString();
        }
        return "";
    }

    public XACMLPolicyQueryType getWrappedObject() {
        return this.internalObject;
    }
}

