/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.ch.ppq.impl.clients;

import org.apache.camel.Exchange;
import org.openehealth.ipf.commons.ihe.xacml20.CH_PPQ;
import org.openehealth.ipf.commons.ihe.xacml20.stub.ehealthswiss.AddPolicyRequest;
import org.openehealth.ipf.commons.ihe.xacml20.stub.ehealthswiss.DeletePolicyRequest;
import org.openehealth.ipf.commons.ihe.xacml20.stub.ehealthswiss.EprPolicyRepositoryResponse;
import org.openehealth.ipf.commons.ihe.xacml20.stub.ehealthswiss.UpdatePolicyRequest;
import org.projecthusky.communication.CamelService;
import org.projecthusky.communication.ch.ppq.api.PrivacyPolicyFeed;
import org.projecthusky.communication.ch.ppq.api.PrivacyPolicyFeedResponse;
import org.projecthusky.communication.ch.ppq.api.clients.PpfClient;
import org.projecthusky.communication.ch.ppq.api.config.PpClientConfig;
import org.projecthusky.communication.ch.ppq.impl.PrivacyPolicyFeedResponseBuilderImpl;
import org.projecthusky.communication.utils.HuskyUtils;
import org.projecthusky.xua.core.SecurityHeaderElement;

public class SimplePpfClient
extends CamelService
implements PpfClient {
    private PpClientConfig config;

    public SimplePpfClient(PpClientConfig clientConfiguration) {
        this.config = clientConfiguration;
    }

    @Override
    public PrivacyPolicyFeedResponse send(SecurityHeaderElement aAssertion, PrivacyPolicyFeed request) {
        try {
            AddPolicyRequest requestToSend = null;
            if (request != null) {
                if (PrivacyPolicyFeed.PpfMethod.ADD_POLICY.equals((Object)request.getMethod())) {
                    requestToSend = new AddPolicyRequest();
                } else if (PrivacyPolicyFeed.PpfMethod.DELETE_POLICY.equals((Object)request.getMethod())) {
                    requestToSend = new DeletePolicyRequest();
                } else if (PrivacyPolicyFeed.PpfMethod.UPDATE_POLICY.equals((Object)request.getMethod())) {
                    requestToSend = new UpdatePolicyRequest();
                }
                if (requestToSend != null) {
                    requestToSend.setAssertion(request.getAssertion());
                    boolean secure = this.config.getUrl().contains("https://");
                    String endpoint = HuskyUtils.createEndpoint((String)CH_PPQ.Interactions.CH_PPQ_1.getWsTransactionConfiguration().getName(), (String)this.config.getUrl(), (boolean)secure, (boolean)this.getAuditContext().isAuditEnabled());
                    Exchange exchange = this.send(endpoint, requestToSend, aAssertion, null, null);
                    if (exchange.getException() != null) {
                        return new PrivacyPolicyFeedResponseBuilderImpl().exception(exchange.getException()).method(request.getMethod()).create();
                    }
                    EprPolicyRepositoryResponse response = (EprPolicyRepositoryResponse)exchange.getMessage().getBody(EprPolicyRepositoryResponse.class);
                    return new PrivacyPolicyFeedResponseBuilderImpl().status(response.getStatus()).method(request.getMethod()).create();
                }
            }
        }
        catch (Exception e) {
            return new PrivacyPolicyFeedResponseBuilderImpl().exception(e).method(request.getMethod()).create();
        }
        return null;
    }
}

