/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.ch.ppq.impl.clients;

import java.util.GregorianCalendar;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.apache.camel.Exchange;
import org.herasaf.xacml.core.context.impl.AttributeType;
import org.herasaf.xacml.core.context.impl.AttributeValueType;
import org.herasaf.xacml.core.context.impl.RequestType;
import org.herasaf.xacml.core.context.impl.ResourceType;
import org.herasaf.xacml.core.dataTypeAttribute.DataTypeAttribute;
import org.openehealth.ipf.commons.ihe.xacml20.CH_PPQ;
import org.openehealth.ipf.commons.ihe.xacml20.herasaf.types.IiDataTypeAttribute;
import org.openehealth.ipf.commons.ihe.xacml20.stub.hl7v3.II;
import org.openehealth.ipf.commons.ihe.xacml20.stub.saml20.protocol.ResponseType;
import org.openehealth.ipf.commons.ihe.xacml20.stub.xacml20.saml.protocol.XACMLPolicyQueryType;
import org.projecthusky.communication.CamelService;
import org.projecthusky.communication.ch.ppq.api.PrivacyPolicyQuery;
import org.projecthusky.communication.ch.ppq.api.PrivacyPolicyQueryResponse;
import org.projecthusky.communication.ch.ppq.api.clients.PpqClient;
import org.projecthusky.communication.ch.ppq.api.config.PpClientConfig;
import org.projecthusky.communication.ch.ppq.impl.PrivacyPolicyQueryResponseBuilderImpl;
import org.projecthusky.communication.utils.HuskyUtils;
import org.projecthusky.xua.core.SecurityHeaderElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimplePpqClient
extends CamelService
implements PpqClient {
    private static Logger log = LoggerFactory.getLogger(SimplePpqClient.class);
    private PpClientConfig config;

    public SimplePpqClient(PpClientConfig clientConfiguration) {
        this.config = clientConfiguration;
    }

    @Override
    public PrivacyPolicyQueryResponse send(SecurityHeaderElement aAssertion, PrivacyPolicyQuery query) {
        try {
            if (query != null) {
                XACMLPolicyQueryType requestToSend = this.convertPrivacyPolicyQuery(query);
                boolean secure = this.config.getUrl().contains("https://");
                String endpoint = HuskyUtils.createEndpoint((String)CH_PPQ.Interactions.CH_PPQ_2.getWsTransactionConfiguration().getName(), (String)this.config.getUrl(), (boolean)secure, (boolean)this.getAuditContext().isAuditEnabled());
                Exchange exchange = this.send(endpoint, requestToSend, aAssertion, null, null);
                ResponseType response = (ResponseType)exchange.getMessage().getBody(ResponseType.class);
                return new PrivacyPolicyQueryResponseBuilderImpl().create(response);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private XACMLPolicyQueryType convertPrivacyPolicyQuery(PrivacyPolicyQuery query) {
        XACMLPolicyQueryType request = new XACMLPolicyQueryType();
        request.setConsent(query.getConsent());
        request.setDestination(query.getDestination());
        request.setID(query.getId());
        request.setVersion("2.0");
        XMLGregorianCalendar xmlGregCal = null;
        try {
            GregorianCalendar retVal = new GregorianCalendar();
            retVal.setTimeInMillis(query.getIssueInstant().getTimeInMillis());
            xmlGregCal = DatatypeFactory.newInstance().newXMLGregorianCalendar(retVal);
            request.setIssueInstant(xmlGregCal);
        }
        catch (DatatypeConfigurationException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        RequestType requestType = new RequestType();
        ResourceType resourceType = new ResourceType();
        AttributeType attributeType = new AttributeType();
        attributeType.setAttributeId("urn:e-health-suisse:2015:epr-spid");
        attributeType.setDataType((DataTypeAttribute)new IiDataTypeAttribute());
        AttributeValueType attributeValueType = new AttributeValueType();
        if (query.getInstanceIdentifier() != null) {
            II instanceIdent = new II();
            instanceIdent.setExtension(query.getInstanceIdentifier().getExtension());
            instanceIdent.setRoot(query.getInstanceIdentifier().getRoot());
            attributeValueType.getContent().add(new JAXBElement(new QName("urn:hl7-org:v3", "InstanceIdentifier"), II.class, (Object)instanceIdent));
        }
        attributeType.getAttributeValues().add(attributeValueType);
        resourceType.getAttributes().add(attributeType);
        requestType.getResources().add(resourceType);
        request.getRequestOrPolicySetIdReferenceOrPolicyIdReference().add(new JAXBElement(new QName("urn:oasis:names:tc:xacml:2.0:context:schema:os", "Request"), RequestType.class, (Object)requestType));
        return request;
    }
}

