/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.services;

import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Enumerations;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.projecthusky.common.enums.TelecomAddressUse;
import org.projecthusky.communication.utils.ConverterUtil;

public class ConverterUtilTest {
    @Test
    public void whenConvertingAdministrativeGenderToString_andGivingNullObject_thenExceptionIsThrown() {
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ConverterUtil.convertAdministrativeGenderToSingleCharString(null));
        Assertions.assertEquals((Object)"The AdministrativeGender parameter must not be null.", (Object)exception.getMessage());
    }

    @Test
    public void whenConvertingAdministrativeGenderToString_thenCorrectValuesAreReturned() {
        Assertions.assertEquals((Object)"M", (Object)ConverterUtil.convertAdministrativeGenderToSingleCharString((Enumerations.AdministrativeGender)Enumerations.AdministrativeGender.MALE));
        Assertions.assertEquals((Object)"F", (Object)ConverterUtil.convertAdministrativeGenderToSingleCharString((Enumerations.AdministrativeGender)Enumerations.AdministrativeGender.FEMALE));
        Assertions.assertEquals((Object)"U", (Object)ConverterUtil.convertAdministrativeGenderToSingleCharString((Enumerations.AdministrativeGender)Enumerations.AdministrativeGender.OTHER));
        Assertions.assertEquals((Object)"U", (Object)ConverterUtil.convertAdministrativeGenderToSingleCharString((Enumerations.AdministrativeGender)Enumerations.AdministrativeGender.UNKNOWN));
        Assertions.assertEquals((Object)"U", (Object)ConverterUtil.convertAdministrativeGenderToSingleCharString((Enumerations.AdministrativeGender)Enumerations.AdministrativeGender.NULL));
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ConverterUtil.convertAdministrativeGenderToSingleCharString(null));
        Assertions.assertEquals((Object)"The AdministrativeGender parameter must not be null.", (Object)exception.getMessage());
    }

    @Test
    public void whenConvertingContactPointTypeToString_andGivingNullObject_thenExceptionIsThrown() {
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ConverterUtil.convertContactPointToTypeString(null));
        Assertions.assertEquals((Object)"The ContactPoint parameter nust not be null.", (Object)exception.getMessage());
    }

    @Test
    public void whenConvertingContactPointTypeToString_thenCorrectValuesAreReturned() {
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ConverterUtil.convertContactPointToTypeString(null));
        Assertions.assertEquals((Object)"The ContactPoint parameter nust not be null.", (Object)exception.getMessage());
        ContactPoint contactPoint = new ContactPoint();
        contactPoint.setSystem(ContactPoint.ContactPointSystem.PHONE);
        contactPoint.setUse(ContactPoint.ContactPointUse.HOME);
        Assertions.assertEquals((Object)"HP", (Object)ConverterUtil.convertContactPointToTypeString((ContactPoint)contactPoint));
        contactPoint = new ContactPoint();
        contactPoint.setSystem(ContactPoint.ContactPointSystem.PHONE);
        contactPoint.setUse(ContactPoint.ContactPointUse.WORK);
        Assertions.assertEquals((Object)"WP", (Object)ConverterUtil.convertContactPointToTypeString((ContactPoint)contactPoint));
        contactPoint = new ContactPoint();
        contactPoint.setSystem(ContactPoint.ContactPointSystem.PHONE);
        contactPoint.setUse(ContactPoint.ContactPointUse.MOBILE);
        Assertions.assertEquals((Object)"", (Object)ConverterUtil.convertContactPointToTypeString((ContactPoint)contactPoint));
        contactPoint = new ContactPoint();
        contactPoint.setSystem(ContactPoint.ContactPointSystem.PHONE);
        contactPoint.setUse(ContactPoint.ContactPointUse.TEMP);
        Assertions.assertEquals((Object)"", (Object)ConverterUtil.convertContactPointToTypeString((ContactPoint)contactPoint));
        contactPoint = new ContactPoint();
        contactPoint.setSystem(ContactPoint.ContactPointSystem.PHONE);
        contactPoint.setUse(ContactPoint.ContactPointUse.OLD);
        Assertions.assertEquals((Object)"", (Object)ConverterUtil.convertContactPointToTypeString((ContactPoint)contactPoint));
        contactPoint = new ContactPoint();
        contactPoint.setSystem(ContactPoint.ContactPointSystem.PHONE);
        contactPoint.setUse(ContactPoint.ContactPointUse.NULL);
        Assertions.assertEquals((Object)"", (Object)ConverterUtil.convertContactPointToTypeString((ContactPoint)contactPoint));
        contactPoint = new ContactPoint();
        contactPoint.setSystem(ContactPoint.ContactPointSystem.EMAIL);
        Assertions.assertEquals((Object)"", (Object)ConverterUtil.convertContactPointToTypeString((ContactPoint)contactPoint));
        contactPoint = new ContactPoint();
        contactPoint.setSystem(ContactPoint.ContactPointSystem.FAX);
        Assertions.assertEquals((Object)"", (Object)ConverterUtil.convertContactPointToTypeString((ContactPoint)contactPoint));
        contactPoint = new ContactPoint();
        contactPoint.setSystem(ContactPoint.ContactPointSystem.PAGER);
        Assertions.assertEquals((Object)"", (Object)ConverterUtil.convertContactPointToTypeString((ContactPoint)contactPoint));
        contactPoint = new ContactPoint();
        contactPoint.setSystem(ContactPoint.ContactPointSystem.SMS);
        Assertions.assertEquals((Object)"", (Object)ConverterUtil.convertContactPointToTypeString((ContactPoint)contactPoint));
        contactPoint = new ContactPoint();
        contactPoint.setSystem(ContactPoint.ContactPointSystem.URL);
        Assertions.assertEquals((Object)"", (Object)ConverterUtil.convertContactPointToTypeString((ContactPoint)contactPoint));
        contactPoint = new ContactPoint();
        contactPoint.setSystem(ContactPoint.ContactPointSystem.OTHER);
        Assertions.assertEquals((Object)"", (Object)ConverterUtil.convertContactPointToTypeString((ContactPoint)contactPoint));
        contactPoint = new ContactPoint();
        contactPoint.setSystem(ContactPoint.ContactPointSystem.NULL);
        Assertions.assertEquals((Object)"", (Object)ConverterUtil.convertContactPointToTypeString((ContactPoint)contactPoint));
    }

    @Test
    public void whenReadingContactPointValue_andGivingNullObject_thenExceptionIsThrown() {
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ConverterUtil.getTelecomValue(null));
        Assertions.assertEquals((Object)"The ContactPoint parameter must not be null.", (Object)exception.getMessage());
    }

    @Test
    public void whenReadingContactPointValue_thenCorrectValuesAreRead() {
        Assertions.assertEquals((Object)"NULL", (Object)ConverterUtil.getTelecomValue((ContactPoint)new ContactPoint()));
        Assertions.assertEquals((Object)"NULL", (Object)ConverterUtil.getTelecomValue((ContactPoint)new ContactPoint().setSystem(null)));
        Assertions.assertEquals((Object)"tel:00436668883355", (Object)ConverterUtil.getTelecomValue((ContactPoint)new ContactPoint().setSystem(ContactPoint.ContactPointSystem.PHONE).setValue("00436668883355")));
        Assertions.assertEquals((Object)"tel:NULL", (Object)ConverterUtil.getTelecomValue((ContactPoint)new ContactPoint().setSystem(ContactPoint.ContactPointSystem.PHONE).setValue(null)));
        Assertions.assertEquals((Object)"mailto:droid@hzb.tor", (Object)ConverterUtil.getTelecomValue((ContactPoint)new ContactPoint().setSystem(ContactPoint.ContactPointSystem.EMAIL).setValue("droid@hzb.tor")));
        Assertions.assertEquals((Object)"mailto:NULL", (Object)ConverterUtil.getTelecomValue((ContactPoint)new ContactPoint().setSystem(ContactPoint.ContactPointSystem.EMAIL).setValue(null)));
        Assertions.assertEquals((Object)"NULL", (Object)ConverterUtil.getTelecomValue((ContactPoint)new ContactPoint().setSystem(ContactPoint.ContactPointSystem.FAX).setValue(null)));
        Assertions.assertEquals((Object)"NULL", (Object)ConverterUtil.getTelecomValue((ContactPoint)new ContactPoint().setSystem(ContactPoint.ContactPointSystem.PAGER).setValue(null)));
        Assertions.assertEquals((Object)"NULL", (Object)ConverterUtil.getTelecomValue((ContactPoint)new ContactPoint().setSystem(ContactPoint.ContactPointSystem.SMS).setValue(null)));
        Assertions.assertEquals((Object)"NULL", (Object)ConverterUtil.getTelecomValue((ContactPoint)new ContactPoint().setSystem(ContactPoint.ContactPointSystem.URL).setValue(null)));
        Assertions.assertEquals((Object)"NULL", (Object)ConverterUtil.getTelecomValue((ContactPoint)new ContactPoint().setSystem(ContactPoint.ContactPointSystem.OTHER).setValue(null)));
        Assertions.assertEquals((Object)"NULL", (Object)ConverterUtil.getTelecomValue((ContactPoint)new ContactPoint().setSystem(ContactPoint.ContactPointSystem.NULL).setValue(null)));
        Assertions.assertEquals((Object)"+41 1 27 776 555 11", (Object)ConverterUtil.getTelecomValue((ContactPoint)new ContactPoint().setSystem(ContactPoint.ContactPointSystem.FAX).setValue("+41 1 27 776 555 11")));
        Assertions.assertEquals((Object)"+41 1 77 8888 19 60", (Object)ConverterUtil.getTelecomValue((ContactPoint)new ContactPoint().setSystem(ContactPoint.ContactPointSystem.PAGER).setValue("+41 1 77 8888 19 60")));
        Assertions.assertEquals((Object)"00436668883355", (Object)ConverterUtil.getTelecomValue((ContactPoint)new ContactPoint().setSystem(ContactPoint.ContactPointSystem.SMS).setValue("00436668883355")));
        Assertions.assertEquals((Object)"www.checkme.out", (Object)ConverterUtil.getTelecomValue((ContactPoint)new ContactPoint().setSystem(ContactPoint.ContactPointSystem.URL).setValue("www.checkme.out")));
        Assertions.assertEquals((Object)"OTHER CONTACT", (Object)ConverterUtil.getTelecomValue((ContactPoint)new ContactPoint().setSystem(ContactPoint.ContactPointSystem.OTHER).setValue("OTHER CONTACT")));
        Assertions.assertEquals((Object)"whatever - but not ignored", (Object)ConverterUtil.getTelecomValue((ContactPoint)new ContactPoint().setSystem(ContactPoint.ContactPointSystem.NULL).setValue("whatever - but not ignored")));
    }

    @Test
    void whenReadingTelecomAddress_andGivingNullObject_thenExceptionIsThrown() throws Exception {
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ConverterUtil.getTelecomAddressUse(null));
        Assertions.assertEquals((Object)"The ContactPoint parameter must not be null.", (Object)exception.getMessage());
    }

    @Test
    void whenReadingTelecomAddress_thenCorrectValueIsRead() throws Exception {
        Assertions.assertEquals(null, (Object)ConverterUtil.getTelecomAddressUse((ContactPoint)new ContactPoint()));
        Assertions.assertEquals(null, (Object)ConverterUtil.getTelecomAddressUse((ContactPoint)new ContactPoint().setUse(null)));
        Assertions.assertEquals((Object)TelecomAddressUse.PRIVATE.getCodeValue(), (Object)ConverterUtil.getTelecomAddressUse((ContactPoint)new ContactPoint().setUse(ContactPoint.ContactPointUse.HOME)));
        Assertions.assertEquals((Object)TelecomAddressUse.BUSINESS.getCodeValue(), (Object)ConverterUtil.getTelecomAddressUse((ContactPoint)new ContactPoint().setUse(ContactPoint.ContactPointUse.WORK)));
        Assertions.assertEquals(null, (Object)ConverterUtil.getTelecomAddressUse((ContactPoint)new ContactPoint().setUse(ContactPoint.ContactPointUse.MOBILE)));
        Assertions.assertEquals(null, (Object)ConverterUtil.getTelecomAddressUse((ContactPoint)new ContactPoint().setUse(ContactPoint.ContactPointUse.TEMP)));
        Assertions.assertEquals(null, (Object)ConverterUtil.getTelecomAddressUse((ContactPoint)new ContactPoint().setUse(ContactPoint.ContactPointUse.OLD)));
        Assertions.assertEquals(null, (Object)ConverterUtil.getTelecomAddressUse((ContactPoint)new ContactPoint().setUse(ContactPoint.ContactPointUse.NULL)));
    }
}

