/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.services;

import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Organization;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.projecthusky.common.communication.Destination;
import org.projecthusky.communication.requests.pdq.PdqSearchQuery;
import org.projecthusky.communication.requests.pix.PixAddPatientFeed;
import org.projecthusky.communication.services.HuskyService;

public class HuskyServiceNoContextUnitTest {
    private HuskyService service = new HuskyService(null);

    @Test
    void queryCreatorSelectorsAreReal() {
        Assertions.assertNotNull((Object)this.service.createPdqSearchQuery(new Destination()));
    }

    @Test
    void whenQueryPatientsQueryBuilderIsStarted_thenNotNullObjectIsReturned() {
        Assertions.assertNotNull((Object)this.service.createPdqSearchQuery(new Destination()).build());
    }

    @Test
    public void whenBuildingQueryWithNullDestination_thenExceptionIsThrown() {
        NullPointerException exception = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> this.service.createPdqSearchQuery(null));
        Assertions.assertEquals((Object)"destination is marked non-null but is null", (Object)exception.getMessage());
    }

    @Test
    public void whenBuildingQueryWithDestination_andSettingNullLater_thenExceptionIsThrown() {
        NullPointerException exception = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> this.service.createPdqSearchQuery(new Destination()).destination(null));
        Assertions.assertEquals((Object)"destination is marked non-null but is null", (Object)exception.getMessage());
    }

    @Test
    public void whenSendingNullQuery_thenIllegalArgumentExceptionIsThrown() {
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.service.send((PdqSearchQuery)null));
        Assertions.assertEquals((Object)"The search query can not be null.", (Object)exception.getMessage());
    }

    @Test
    public void whenAddingTwoIdentifiersForNewPatient_thenListIsFilledWithTwo() {
        PixAddPatientFeed feed = this.service.createPixAddPatientFeed(new Destination(), new Organization()).identifier(new Identifier()).identifier(new Identifier()).build();
        Assertions.assertEquals((int)2, (int)feed.getIdentifiers().size());
    }

    @Test
    @Disabled(value="Until scoping organization is no longer used as fallback")
    public void whenNoScopingOrganizationIsPresentInAddFeed_thenExceptionIsThrown() {
        NullPointerException exception = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> this.service.createPixAddPatientFeed(new Destination(), null).build());
        Assertions.assertEquals((Object)"scopingOrganization is marked non-null but is null", (Object)exception.getMessage());
    }
}

