/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.services.pdq;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.projecthusky.common.communication.Destination;
import org.projecthusky.communication.requests.pdq.PdqSearchQuery;

public class PdqSearchQueryBuilderTest {
    @Test
    public void whenNoDestinationIsSet_thenBuildingTheQueryThrowsAnException() {
        NullPointerException resultingException = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> PdqSearchQuery.builder().build());
        Assertions.assertEquals((Object)"destination is marked non-null but is null", (Object)resultingException.getMessage());
    }

    @Test
    public void whenDestinationIsSetToNull_thenExceptionIsThrown() {
        NullPointerException resultingException = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> PdqSearchQuery.builder().destination(null));
        Assertions.assertEquals((Object)"destination is marked non-null but is null", (Object)resultingException.getMessage());
    }

    @Test
    public void whenDomainsToReturnAreNotAdded_thenListIsStillNotNull() {
        PdqSearchQuery query = PdqSearchQuery.builder().destination(new Destination()).build();
        Assertions.assertNotNull((Object)query);
        Assertions.assertNotNull((Object)query.getDomainsToReturn());
    }
}

