/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.services.pix;

import org.hl7.fhir.r4.model.Organization;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.projecthusky.common.communication.Destination;
import org.projecthusky.communication.requests.pix.PixAddPatientFeed;

public class PixAddPatientFeedTest {
    @Test
    public void whenNoDestinationIsSet_thenBuildingTheQueryThrowsAnException() {
        NullPointerException resultingException = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> PixAddPatientFeed.builder().build());
        Assertions.assertEquals((Object)"destination is marked non-null but is null", (Object)resultingException.getMessage());
    }

    @Test
    public void whenDestinationIsSetToNull_thenExceptionIsThrown() {
        NullPointerException resultingException = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> PixAddPatientFeed.builder().destination(null));
        Assertions.assertEquals((Object)"destination is marked non-null but is null", (Object)resultingException.getMessage());
    }

    @Test
    @Disabled(value="Until scoping organization is no longer used as fallback")
    void whenDestinationIsNotNull_butProviderOrganizationIsNotSet_thenExceptionIsThrown() throws Exception {
        NullPointerException resultingException = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> PixAddPatientFeed.builder().destination(new Destination()).build());
        Assertions.assertEquals((Object)"providerOrganization is marked non-null but is null", (Object)resultingException.getMessage());
    }

    @Test
    @Disabled(value="Until scoping organization is no longer used as fallback")
    void whenDestinationIsNotNull_andProviderOrganizationIsSetToNull_thenExceptionIsThrown() throws Exception {
        NullPointerException resultingException = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> PixAddPatientFeed.builder().destination(new Destination()).providerOrganization(null));
        Assertions.assertEquals((Object)"providerOrganization is marked non-null but is null", (Object)resultingException.getMessage());
    }

    @Test
    public void whenBuilderIsBuilt_withMinimalParameters_thenListsAreInitializedByLombokAsEmplty() {
        PixAddPatientFeed addPatientQuery = PixAddPatientFeed.builder().destination(new Destination()).providerOrganization(new Organization()).build();
        Assertions.assertNotNull((Object)addPatientQuery);
        Assertions.assertNotNull((Object)addPatientQuery.getIdentifiers());
        Assertions.assertNotNull((Object)addPatientQuery.getNonMedicalIdentifiers());
        Assertions.assertNotNull((Object)addPatientQuery.getAddresses());
        Assertions.assertNotNull((Object)addPatientQuery.getLanguages());
        Assertions.assertNotNull((Object)addPatientQuery.getTelecomContacts());
        Assertions.assertEquals((int)0, (int)addPatientQuery.getIdentifiers().size());
        Assertions.assertEquals((int)0, (int)addPatientQuery.getNonMedicalIdentifiers().size());
        Assertions.assertEquals((int)0, (int)addPatientQuery.getAddresses().size());
        Assertions.assertEquals((int)0, (int)addPatientQuery.getLanguages().size());
        Assertions.assertEquals((int)0, (int)addPatientQuery.getTelecomContacts().size());
    }
}

