/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http.v1api;

import java.util.stream.Stream;
import org.projectnessie.api.params.RefLogParams;
import org.projectnessie.api.params.RefLogParamsBuilder;
import org.projectnessie.client.StreamingUtil;
import org.projectnessie.client.api.GetRefLogBuilder;
import org.projectnessie.client.http.NessieApiClient;
import org.projectnessie.client.http.v1api.BaseHttpRequest;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.RefLogResponse;

final class HttpGetRefLog
extends BaseHttpRequest
implements GetRefLogBuilder {
    private final RefLogParamsBuilder params = RefLogParams.builder();

    HttpGetRefLog(NessieApiClient client) {
        super(client);
    }

    @Override
    public GetRefLogBuilder untilHash(String untilHash) {
        this.params.startHash(untilHash);
        return this;
    }

    @Override
    public GetRefLogBuilder fromHash(String fromHash) {
        this.params.endHash(fromHash);
        return this;
    }

    @Override
    public GetRefLogBuilder filter(String filter) {
        this.params.filter(filter);
        return this;
    }

    @Override
    public GetRefLogBuilder maxRecords(int maxRecords) {
        this.params.maxRecords(Integer.valueOf(maxRecords));
        return this;
    }

    @Override
    public GetRefLogBuilder pageToken(String pageToken) {
        this.params.pageToken(pageToken);
        return this;
    }

    private RefLogParams params() {
        return this.params.build();
    }

    @Override
    public RefLogResponse get() throws NessieNotFoundException {
        return this.get(this.params());
    }

    private RefLogResponse get(RefLogParams p) throws NessieNotFoundException {
        return this.client.getRefLogApi().getRefLog(p);
    }

    @Override
    public Stream<RefLogResponse.RefLogResponseEntry> stream() throws NessieNotFoundException {
        RefLogParams p = this.params();
        return StreamingUtil.generateStream(RefLogResponse::getLogEntries, pageToken -> this.get(p.forNextPage(pageToken)));
    }
}

