/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.contentgenerator;

import java.util.UUID;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.http.HttpClientBuilder;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;

public class AbstractContentGeneratorTest {
    static final Integer NESSIE_HTTP_PORT = Integer.getInteger("quarkus.http.test-port");
    static final String NESSIE_API_URI = String.format("http://localhost:%d/api/v1", NESSIE_HTTP_PORT);
    protected static final String COMMIT_MSG = "testMessage";
    protected static final ContentKey CONTENT_KEY = ContentKey.of((String[])new String[]{"first", "second"});

    protected Branch makeCommit(NessieApiV1 api, String contentId) throws NessieConflictException, NessieNotFoundException {
        String branchName = "test-" + UUID.randomUUID();
        Branch main = api.getDefaultBranch();
        Reference branch = api.createReference().sourceRefName(main.getName()).reference((Reference)Branch.of((String)branchName, (String)main.getHash())).create();
        return ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)api.commitMultipleOperations().branchName(branch.getName())).hash(branch.getHash())).commitMeta(CommitMeta.fromMessage((String)COMMIT_MSG)).operation((Operation)Operation.Put.of((ContentKey)CONTENT_KEY, (Content)IcebergTable.of((String)"testMeta", (long)123L, (int)456, (int)789, (int)321, (String)contentId))).commit();
    }

    protected NessieApiV1 buildNessieApi() {
        return (NessieApiV1)((HttpClientBuilder)HttpClientBuilder.builder().fromSystemProperties().withUri(NESSIE_API_URI)).build(NessieApiV1.class);
    }
}

