/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.hms;

import org.apache.hadoop.hive.metastore.api.Database;
import org.projectnessie.hms.Item;
import org.projectnessie.model.Contents;
import org.projectnessie.model.HiveDatabase;
import org.projectnessie.model.ImmutableHiveDatabase;

class DatabaseW
extends Item {
    private final Database database;
    private final String id;

    public DatabaseW(Database database, String id) {
        this.database = database;
        this.id = id;
    }

    @Override
    public Item.Type getType() {
        return Item.Type.DATABASE;
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    public HiveDatabase toContents() {
        return ImmutableHiveDatabase.builder().databaseDefinition(DatabaseW.toBytes(this.database)).id(this.id).build();
    }

    public static DatabaseW fromContents(Contents c) {
        if (!(c instanceof HiveDatabase)) {
            throw new RuntimeException("Not a Hive datbaase.");
        }
        return new DatabaseW(DatabaseW.fromBytes(new Database(), ((HiveDatabase)c).getDatabaseDefinition()), c.getId());
    }

    @Override
    public String getId() {
        return this.id;
    }
}

