package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DiffResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDiffResponse.builder()}.
 */
@Generated(from = "DiffResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDiffResponse implements DiffResponse {
  private final List<DiffResponse.DiffEntry> diffs;

  private ImmutableDiffResponse(List<DiffResponse.DiffEntry> diffs) {
    this.diffs = diffs;
  }

  /**
   * @return The value of the {@code diffs} attribute
   */
  @JsonProperty("diffs")
  @Override
  public List<DiffResponse.DiffEntry> diffs() {
    return diffs;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DiffResponse#diffs() diffs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDiffResponse withDiffs(DiffResponse.DiffEntry... elements) {
    List<DiffResponse.DiffEntry> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableDiffResponse(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DiffResponse#diffs() diffs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of diffs elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDiffResponse withDiffs(Iterable<? extends DiffResponse.DiffEntry> elements) {
    if (this.diffs == elements) return this;
    List<DiffResponse.DiffEntry> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableDiffResponse(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDiffResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDiffResponse
        && equalTo((ImmutableDiffResponse) another);
  }

  private boolean equalTo(ImmutableDiffResponse another) {
    return diffs.equals(another.diffs);
  }

  /**
   * Computes a hash code from attributes: {@code diffs}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + diffs.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DiffResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DiffResponse{"
        + "diffs=" + diffs
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DiffResponse", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DiffResponse {
    @Nullable List<DiffResponse.DiffEntry> diffs = Collections.emptyList();
    @JsonProperty("diffs")
    public void setDiffs(List<DiffResponse.DiffEntry> diffs) {
      this.diffs = diffs;
    }
    @Override
    public List<DiffResponse.DiffEntry> diffs() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDiffResponse fromJson(Json json) {
    ImmutableDiffResponse.Builder builder = ImmutableDiffResponse.builder();
    if (json.diffs != null) {
      builder.addAllDiffs(json.diffs);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DiffResponse} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DiffResponse instance
   */
  public static ImmutableDiffResponse copyOf(DiffResponse instance) {
    if (instance instanceof ImmutableDiffResponse) {
      return (ImmutableDiffResponse) instance;
    }
    return ImmutableDiffResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDiffResponse ImmutableDiffResponse}.
   * <pre>
   * ImmutableDiffResponse.builder()
   *    .addDiffs|addAllDiffs(org.projectnessie.model.DiffResponse.DiffEntry) // {@link DiffResponse#diffs() diffs} elements
   *    .build();
   * </pre>
   * @return A new ImmutableDiffResponse builder
   */
  public static ImmutableDiffResponse.Builder builder() {
    return new ImmutableDiffResponse.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDiffResponse ImmutableDiffResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DiffResponse", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<DiffResponse.DiffEntry> diffs = new ArrayList<DiffResponse.DiffEntry>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DiffResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DiffResponse instance) {
      Objects.requireNonNull(instance, "instance");
      addAllDiffs(instance.diffs());
      return this;
    }

    /**
     * Adds one element to {@link DiffResponse#diffs() diffs} list.
     * @param element A diffs element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addDiffs(DiffResponse.DiffEntry element) {
      this.diffs.add(Objects.requireNonNull(element, "diffs element"));
      return this;
    }

    /**
     * Adds elements to {@link DiffResponse#diffs() diffs} list.
     * @param elements An array of diffs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addDiffs(DiffResponse.DiffEntry... elements) {
      for (DiffResponse.DiffEntry element : elements) {
        this.diffs.add(Objects.requireNonNull(element, "diffs element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DiffResponse#diffs() diffs} list.
     * @param elements An iterable of diffs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("diffs")
    public final Builder diffs(Iterable<? extends DiffResponse.DiffEntry> elements) {
      this.diffs.clear();
      return addAllDiffs(elements);
    }

    /**
     * Adds elements to {@link DiffResponse#diffs() diffs} list.
     * @param elements An iterable of diffs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllDiffs(Iterable<? extends DiffResponse.DiffEntry> elements) {
      for (DiffResponse.DiffEntry element : elements) {
        this.diffs.add(Objects.requireNonNull(element, "diffs element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableDiffResponse ImmutableDiffResponse}.
     * @return An immutable instance of DiffResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDiffResponse build() {
      return new ImmutableDiffResponse(createUnmodifiableList(true, diffs));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
