package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ReferencesResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableReferencesResponse.builder()}.
 */
@Generated(from = "ReferencesResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableReferencesResponse implements ReferencesResponse {
  private final boolean isHasMore;
  private final @Nullable String token;
  private final List<Reference> references;

  private ImmutableReferencesResponse(ImmutableReferencesResponse.Builder builder) {
    this.token = builder.token;
    this.references = createUnmodifiableList(true, builder.references);
    this.isHasMore = builder.isHasMoreIsSet()
        ? builder.isHasMore
        : ReferencesResponse.super.isHasMore();
  }

  private ImmutableReferencesResponse(
      boolean isHasMore,
      @Nullable String token,
      List<Reference> references) {
    this.isHasMore = isHasMore;
    this.token = token;
    this.references = references;
  }

  /**
   * Whether there are more result-items than returned by this response object.
   * <p>If there are more result-items, the value returned by {@link #getToken()} can be used in the
   * next invocation to get the next "page" of results.
   * @return {@code true}, if there are more result items.
   */
  @JsonProperty("hasMore")
  @Override
  public boolean isHasMore() {
    return isHasMore;
  }

  /**
   * Pass this value to the next invocation of the API function to get the next page of results.
   * <p>Paging tokens are opaque and the structure may change without prior notice even in patch
   * releases.
   * @return paging continuation token for the next invocation of an API function taking a subclass
   *     of {@link org.projectnessie.api.params.AbstractParams}, if {@link #isHasMore()} is {@code
   *     true}. Undefined, if {@link #isHasMore()} is {@code false}.
   */
  @JsonProperty("token")
  @Override
  public @Nullable String getToken() {
    return token;
  }

  /**
   * @return The value of the {@code references} attribute
   */
  @JsonProperty("references")
  @Override
  public List<Reference> getReferences() {
    return references;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReferencesResponse#isHasMore() isHasMore} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isHasMore
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReferencesResponse withIsHasMore(boolean value) {
    if (this.isHasMore == value) return this;
    return new ImmutableReferencesResponse(value, this.token, this.references);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReferencesResponse#getToken() token} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for token (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReferencesResponse withToken(@Nullable String value) {
    if (Objects.equals(this.token, value)) return this;
    return new ImmutableReferencesResponse(this.isHasMore, value, this.references);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ReferencesResponse#getReferences() references}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableReferencesResponse withReferences(Reference... elements) {
    List<Reference> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableReferencesResponse(this.isHasMore, this.token, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ReferencesResponse#getReferences() references}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of references elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableReferencesResponse withReferences(Iterable<? extends Reference> elements) {
    if (this.references == elements) return this;
    List<Reference> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableReferencesResponse(this.isHasMore, this.token, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableReferencesResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableReferencesResponse
        && equalTo((ImmutableReferencesResponse) another);
  }

  private boolean equalTo(ImmutableReferencesResponse another) {
    return isHasMore == another.isHasMore
        && Objects.equals(token, another.token)
        && references.equals(another.references);
  }

  /**
   * Computes a hash code from attributes: {@code isHasMore}, {@code token}, {@code references}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Boolean.hashCode(isHasMore);
    h += (h << 5) + Objects.hashCode(token);
    h += (h << 5) + references.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ReferencesResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ReferencesResponse{"
        + "isHasMore=" + isHasMore
        + ", token=" + token
        + ", references=" + references
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ReferencesResponse", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ReferencesResponse {
    boolean isHasMore;
    boolean isHasMoreIsSet;
    @Nullable String token;
    @Nullable List<Reference> references = Collections.emptyList();
    @JsonProperty("hasMore")
    public void setIsHasMore(boolean isHasMore) {
      this.isHasMore = isHasMore;
      this.isHasMoreIsSet = true;
    }
    @JsonProperty("token")
    public void setToken(@Nullable String token) {
      this.token = token;
    }
    @JsonProperty("references")
    public void setReferences(List<Reference> references) {
      this.references = references;
    }
    @Override
    public boolean isHasMore() { throw new UnsupportedOperationException(); }
    @Override
    public String getToken() { throw new UnsupportedOperationException(); }
    @Override
    public List<Reference> getReferences() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableReferencesResponse fromJson(Json json) {
    ImmutableReferencesResponse.Builder builder = ImmutableReferencesResponse.builder();
    if (json.isHasMoreIsSet) {
      builder.isHasMore(json.isHasMore);
    }
    if (json.token != null) {
      builder.token(json.token);
    }
    if (json.references != null) {
      builder.addAllReferences(json.references);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ReferencesResponse} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ReferencesResponse instance
   */
  public static ImmutableReferencesResponse copyOf(ReferencesResponse instance) {
    if (instance instanceof ImmutableReferencesResponse) {
      return (ImmutableReferencesResponse) instance;
    }
    return ImmutableReferencesResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableReferencesResponse ImmutableReferencesResponse}.
   * <pre>
   * ImmutableReferencesResponse.builder()
   *    .isHasMore(boolean) // optional {@link ReferencesResponse#isHasMore() isHasMore}
   *    .token(String | null) // nullable {@link ReferencesResponse#getToken() token}
   *    .addReferences|addAllReferences(org.projectnessie.model.Reference) // {@link ReferencesResponse#getReferences() references} elements
   *    .build();
   * </pre>
   * @return A new ImmutableReferencesResponse builder
   */
  public static ImmutableReferencesResponse.Builder builder() {
    return new ImmutableReferencesResponse.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableReferencesResponse ImmutableReferencesResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ReferencesResponse", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_IS_HAS_MORE = 0x1L;
    private long optBits;

    private boolean isHasMore;
    private @Nullable String token;
    private List<Reference> references = new ArrayList<Reference>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.model.ReferencesResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ReferencesResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.model.PaginatedResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(PaginatedResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof ReferencesResponse) {
        ReferencesResponse instance = (ReferencesResponse) object;
        addAllReferences(instance.getReferences());
      }
      if (object instanceof PaginatedResponse) {
        PaginatedResponse instance = (PaginatedResponse) object;
        isHasMore(instance.isHasMore());
        @Nullable String tokenValue = instance.getToken();
        if (tokenValue != null) {
          token(tokenValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link ReferencesResponse#isHasMore() isHasMore} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ReferencesResponse#isHasMore() isHasMore}.</em>
     * @param isHasMore The value for isHasMore 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("hasMore")
    public final Builder isHasMore(boolean isHasMore) {
      this.isHasMore = isHasMore;
      optBits |= OPT_BIT_IS_HAS_MORE;
      return this;
    }

    /**
     * Initializes the value for the {@link ReferencesResponse#getToken() token} attribute.
     * @param token The value for token (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("token")
    public final Builder token(@Nullable String token) {
      this.token = token;
      return this;
    }

    /**
     * Adds one element to {@link ReferencesResponse#getReferences() references} list.
     * @param element A references element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addReferences(Reference element) {
      this.references.add(Objects.requireNonNull(element, "references element"));
      return this;
    }

    /**
     * Adds elements to {@link ReferencesResponse#getReferences() references} list.
     * @param elements An array of references elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addReferences(Reference... elements) {
      for (Reference element : elements) {
        this.references.add(Objects.requireNonNull(element, "references element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ReferencesResponse#getReferences() references} list.
     * @param elements An iterable of references elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("references")
    public final Builder references(Iterable<? extends Reference> elements) {
      this.references.clear();
      return addAllReferences(elements);
    }

    /**
     * Adds elements to {@link ReferencesResponse#getReferences() references} list.
     * @param elements An iterable of references elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllReferences(Iterable<? extends Reference> elements) {
      for (Reference element : elements) {
        this.references.add(Objects.requireNonNull(element, "references element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableReferencesResponse ImmutableReferencesResponse}.
     * @return An immutable instance of ReferencesResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableReferencesResponse build() {
      return new ImmutableReferencesResponse(this);
    }

    private boolean isHasMoreIsSet() {
      return (optBits & OPT_BIT_IS_HAS_MORE) != 0;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
