package org.projectnessie.model;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TableReference}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTableReference.builder()}.
 */
@Generated(from = "TableReference", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableTableReference extends TableReference {
  private final String name;
  private final @Nullable String reference;
  private final @Nullable String timestamp;
  private final @Nullable String hash;

  private ImmutableTableReference(
      String name,
      @Nullable String reference,
      @Nullable String timestamp,
      @Nullable String hash) {
    this.name = name;
    this.reference = reference;
    this.timestamp = timestamp;
    this.hash = hash;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code reference} attribute
   */
  @Override
  public @Nullable String getReference() {
    return reference;
  }

  /**
   * @return The value of the {@code timestamp} attribute
   */
  @Override
  public @Nullable String getTimestamp() {
    return timestamp;
  }

  /**
   * @return The value of the {@code hash} attribute
   */
  @Override
  public @Nullable String getHash() {
    return hash;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TableReference#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTableReference withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableTableReference(newValue, this.reference, this.timestamp, this.hash);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TableReference#getReference() reference} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reference (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTableReference withReference(@Nullable String value) {
    if (Objects.equals(this.reference, value)) return this;
    return new ImmutableTableReference(this.name, value, this.timestamp, this.hash);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TableReference#getTimestamp() timestamp} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for timestamp (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTableReference withTimestamp(@Nullable String value) {
    if (Objects.equals(this.timestamp, value)) return this;
    return new ImmutableTableReference(this.name, this.reference, value, this.hash);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TableReference#getHash() hash} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hash (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTableReference withHash(@Nullable String value) {
    if (Objects.equals(this.hash, value)) return this;
    return new ImmutableTableReference(this.name, this.reference, this.timestamp, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTableReference} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTableReference
        && equalTo((ImmutableTableReference) another);
  }

  private boolean equalTo(ImmutableTableReference another) {
    return name.equals(another.name)
        && Objects.equals(reference, another.reference)
        && Objects.equals(timestamp, another.timestamp)
        && Objects.equals(hash, another.hash);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code reference}, {@code timestamp}, {@code hash}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(reference);
    h += (h << 5) + Objects.hashCode(timestamp);
    h += (h << 5) + Objects.hashCode(hash);
    return h;
  }

  /**
   * Creates an immutable copy of a {@link TableReference} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TableReference instance
   */
  public static ImmutableTableReference copyOf(TableReference instance) {
    if (instance instanceof ImmutableTableReference) {
      return (ImmutableTableReference) instance;
    }
    return ImmutableTableReference.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTableReference ImmutableTableReference}.
   * <pre>
   * ImmutableTableReference.builder()
   *    .name(String) // required {@link TableReference#getName() name}
   *    .reference(String | null) // nullable {@link TableReference#getReference() reference}
   *    .timestamp(String | null) // nullable {@link TableReference#getTimestamp() timestamp}
   *    .hash(String | null) // nullable {@link TableReference#getHash() hash}
   *    .build();
   * </pre>
   * @return A new ImmutableTableReference builder
   */
  public static ImmutableTableReference.Builder builder() {
    return new ImmutableTableReference.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTableReference ImmutableTableReference}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TableReference", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String name;
    private @Nullable String reference;
    private @Nullable String timestamp;
    private @Nullable String hash;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TableReference} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(TableReference instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      @Nullable String referenceValue = instance.getReference();
      if (referenceValue != null) {
        reference(referenceValue);
      }
      @Nullable String timestampValue = instance.getTimestamp();
      if (timestampValue != null) {
        timestamp(timestampValue);
      }
      @Nullable String hashValue = instance.getHash();
      if (hashValue != null) {
        hash(hashValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link TableReference#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link TableReference#getReference() reference} attribute.
     * @param reference The value for reference (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder reference(@Nullable String reference) {
      this.reference = reference;
      return this;
    }

    /**
     * Initializes the value for the {@link TableReference#getTimestamp() timestamp} attribute.
     * @param timestamp The value for timestamp (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder timestamp(@Nullable String timestamp) {
      this.timestamp = timestamp;
      return this;
    }

    /**
     * Initializes the value for the {@link TableReference#getHash() hash} attribute.
     * @param hash The value for hash (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder hash(@Nullable String hash) {
      this.hash = hash;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTableReference ImmutableTableReference}.
     * @return An immutable instance of TableReference
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTableReference build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTableReference(name, reference, timestamp, hash);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build TableReference, some of required attributes are not set " + attributes;
    }
  }
}
