/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.params;

import java.util.function.Function;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.projectnessie.api.params.AbstractParams;
import org.projectnessie.api.params.CommitLogParams;

public class CommitLogParamsTest {
    @Test
    public void testBuilder() {
        Integer maxRecords = 23;
        String startHash = "1234567890123456";
        String endHash = "00000";
        String pageToken = "aabbcc";
        String queryExpression = "some_expression";
        boolean fetchAdditionalInfo = true;
        Supplier<CommitLogParams> generator = () -> ((CommitLogParams.Builder)((CommitLogParams.Builder)CommitLogParams.builder().expression(queryExpression).maxRecords(maxRecords)).pageToken(pageToken)).startHash(startHash).endHash(endHash).fetchAdditionalInfo(fetchAdditionalInfo).build();
        this.verify(maxRecords, startHash, endHash, pageToken, queryExpression, fetchAdditionalInfo, generator);
    }

    @Test
    public void testEmpty() {
        this.verify(null, null, null, null, null, false, CommitLogParams::empty);
    }

    private void verify(Integer maxRecords, String startHash, String endHash, String pageToken, String queryExpression, boolean fetchAdditionalInfo, Supplier<CommitLogParams> generator) {
        ((ObjectAssert)Assertions.assertThat((Object)generator.get()).isEqualTo((Object)generator.get())).extracting(new Function[]{AbstractParams::pageToken, AbstractParams::maxRecords, CommitLogParams::queryExpression, CommitLogParams::startHash, CommitLogParams::endHash, CommitLogParams::isFetchAdditionalInfo, CommitLogParams::hashCode}).containsExactly(new Object[]{pageToken, maxRecords, queryExpression, startHash, endHash, fetchAdditionalInfo, generator.get().hashCode()});
    }
}

